/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionConverter {
    private static final IModelElement[] EMPTY_RESULT = new IModelElement[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) throws ModelException {
        ISelection selection;
        if (part instanceof IEditorPart) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve((IEditorPart)part));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static IModelElement[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            IModelElement[] result = new IModelElement[selection.size()];
            int i = 0;
            for (Object element : selection) {
                if (!(element instanceof IModelElement)) {
                    return EMPTY_RESULT;
                }
                result[i] = (IModelElement)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static IModelElement[] codeResolveOrInputForked(IEditorPart editor) throws InvocationTargetException, InterruptedException {
        ITextSelection selection;
        IModelElement input = SelectionConverter.getInput(editor);
        IModelElement[] result = SelectionConverter.performForkedCodeResolve(input, selection = SelectionConverter.getTextSelection(editor));
        if (result.length == 0) {
            result = new IModelElement[]{input};
        }
        return result;
    }

    public static IModelElement[] codeResolve(IEditorPart editor) throws ModelException {
        return SelectionConverter.codeResolve(editor, true);
    }

    public static IModelElement[] codeResolve(IEditorPart editor, boolean primaryOnly) throws ModelException {
        return SelectionConverter.codeResolve(SelectionConverter.getInput(editor, primaryOnly), SelectionConverter.getTextSelection(editor));
    }

    public static IModelElement[] codeResolveForked(IEditorPart editor, boolean primaryOnly) throws InvocationTargetException, InterruptedException {
        return SelectionConverter.performForkedCodeResolve(SelectionConverter.getInput(editor, primaryOnly), SelectionConverter.getTextSelection(editor));
    }

    public static IModelElement getElementAtOffset(IEditorPart editor) throws ModelException {
        return SelectionConverter.getElementAtOffset(editor, true);
    }

    private static IModelElement getElementAtOffset(IEditorPart editor, boolean primaryOnly) throws ModelException {
        return SelectionConverter.getElementAtOffset(SelectionConverter.getInput(editor, primaryOnly), SelectionConverter.getTextSelection(editor));
    }

    private static ITextSelection getTextSelection(IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            return (ITextSelection)((ITextEditor)editor).getSelectionProvider().getSelection();
        }
        return TextSelection.emptySelection();
    }

    public static IModelElement getInput(IEditorPart editor) {
        return SelectionConverter.getInput(editor, true);
    }

    private static IModelElement getInput(IEditorPart editor, boolean primaryOnly) {
        if (editor == null) {
            return null;
        }
        return EditorUtility.getEditorInputModelElement(editor, primaryOnly);
    }

    public static ISourceModule getInputAsSourceModule(IEditorPart editor) {
        IModelElement editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof ISourceModule) {
            return (ISourceModule)editorInput;
        }
        return null;
    }

    private static IModelElement[] performForkedCodeResolve(IModelElement input, ITextSelection selection) throws InvocationTargetException, InterruptedException {
        final class CodeResolveRunnable
        implements IRunnableWithProgress {
            IModelElement[] result;
            private final /* synthetic */ IModelElement val$input;
            private final /* synthetic */ ITextSelection val$selection;

            CodeResolveRunnable(IModelElement iModelElement, ITextSelection iTextSelection) {
                this.val$input = iModelElement;
                this.val$selection = iTextSelection;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    this.result = SelectionConverter.codeResolve(this.val$input, this.val$selection);
                }
                catch (ModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
        CodeResolveRunnable runnable = new CodeResolveRunnable(input, selection);
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        return runnable.result;
    }

    public static IModelElement[] codeResolve(IModelElement input, ITextSelection selection) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("SelectionConverter: Add Code assist support");
        }
        if (input instanceof ICodeAssist) {
            IModelElement[] elements;
            if (input instanceof ISourceModule) {
                ScriptModelUtil.reconcile((ISourceModule)((ISourceModule)input));
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    public static IModelElement getElementAtOffset(IModelElement input, ITextSelection selection) throws ModelException {
        if (input instanceof ISourceModule) {
            if (!((ISourceModule)input).exists()) {
                return null;
            }
            ISourceModule cunit = (ISourceModule)input;
            ScriptModelUtil.reconcile((ISourceModule)cunit);
            IModelElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static IModelElement resolveEnclosingElement(IEditorPart editor, ITextSelection selection) throws ModelException {
        return SelectionConverter.resolveEnclosingElement(SelectionConverter.getInput(editor), selection);
    }

    public static IModelElement resolveEnclosingElement(IModelElement input, ITextSelection selection) throws ModelException {
        IModelElement atOffset = null;
        if (!(input instanceof ISourceModule)) {
            return null;
        }
        ISourceModule cunit = (ISourceModule)input;
        ScriptModelUtil.reconcile((ISourceModule)cunit);
        atOffset = cunit.getElementAt(selection.getOffset());
        if (atOffset == null) {
            return input;
        }
        int selectionEnd = selection.getOffset() + selection.getLength();
        IModelElement result = atOffset;
        if (atOffset instanceof ISourceReference) {
            ISourceRange range = ((ISourceReference)atOffset).getSourceRange();
            while (range.getOffset() + range.getLength() < selectionEnd) {
                if (!((result = result.getParent()) instanceof ISourceReference)) {
                    result = input;
                    break;
                }
                range = ((ISourceReference)result).getSourceRange();
            }
        }
        return result;
    }

    public static IModelElement selectModelElement(IModelElement[] elements, Shell shell, String title, String message) {
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = ModelElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ModelElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0) {
            return (IModelElement)dialog.getFirstResult();
        }
        return null;
    }
}

