/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.templates;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.dltk.ui.text.templates.TemplateMessages;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.eclipse.osgi.util.NLS;

public class FileTemplateContextType
extends TemplateContextType {
    public static final String FILENAME = "file_name";
    public static final String FILEBASE = "file_base";
    public static final String FILELOCATION = "file_loc";
    public static final String FILEPATH = "file_path";
    public static final String PROJECTNAME = "project_name";

    public FileTemplateContextType() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new DateVariableResolver());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResourceVariables();
    }

    protected void addResourceVariables() {
        this.addResolver((TemplateVariableResolver)new FileTemplateVariableResolver(FILENAME, TemplateMessages.FileTemplateContextType_variable_description_filename));
        this.addResolver((TemplateVariableResolver)new FileTemplateVariableResolver(FILEBASE, TemplateMessages.FileTemplateContextType_variable_description_filebase));
        this.addResolver((TemplateVariableResolver)new FileTemplateVariableResolver(FILELOCATION, TemplateMessages.FileTemplateContextType_variable_description_fileloc));
        this.addResolver((TemplateVariableResolver)new FileTemplateVariableResolver(FILEPATH, TemplateMessages.FileTemplateContextType_variable_description_filepath));
        this.addResolver((TemplateVariableResolver)new FileTemplateVariableResolver(PROJECTNAME, TemplateMessages.FileTemplateContextType_variable_description_projectname));
    }

    protected TemplateVariableResolver getResolver(String type) {
        if ("file".equals(type)) {
            type = FILENAME;
        } else if ("project".equals(type) || "enclosing_project".equals(type)) {
            type = PROJECTNAME;
        }
        return super.getResolver(type);
    }

    protected void validateVariables(TemplateVariable[] variables) throws TemplateException {
        ArrayList required = new ArrayList(5);
        int i = 0;
        while (i < variables.length) {
            String type = variables[i].getType();
            if (this.getResolver(type) == null) {
                throw new TemplateException(NLS.bind((String)TemplateMessages.FileTemplateContextType_validate_unknownvariable, (Object)type));
            }
            required.remove(type);
            ++i;
        }
        if (!required.isEmpty()) {
            String missing = (String)required.get(0);
            throw new TemplateException(NLS.bind((String)TemplateMessages.FileTemplateContextType_validate_missingvariable, (Object)missing));
        }
        super.validateVariables(variables);
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        String type = variable.getType();
        Object resolver = this.getResolver(type);
        if (resolver == null) {
            resolver = new FileTemplateVariableResolver(type, "");
        }
        resolver.resolve(variable, context);
    }

    static class CoreVariableResolver
    extends SimpleTemplateVariableResolver {
        private String fVariableName;
        private String[] fArguments;

        public CoreVariableResolver(String type) {
            super(type, TemplateMessages.FileTemplateContextType__variable_description_eclipse);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            this.fVariableName = variable.getName();
            TemplateVariableType type = variable.getVariableType();
            List params = type.getParams();
            this.fArguments = params.toArray(new String[params.size()]);
            super.resolve(variable, context);
        }

        protected String resolve(TemplateContext context) {
            StringBuffer expr = new StringBuffer("${");
            expr.append(this.fVariableName);
            int i = 0;
            while (i < this.fArguments.length) {
                expr.append(':').append(this.fArguments[i]);
                ++i;
            }
            expr.append('}');
            IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                return mgr.performStringSubstitution(expr.toString(), false);
            }
            catch (CoreException coreException) {
                return expr.toString();
            }
        }
    }

    static class DateVariableResolver
    extends SimpleTemplateVariableResolver {
        private String fFormat;

        public DateVariableResolver() {
            super("date", TemplateMessages.FileTemplateContextType_variable_description_date);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            this.fFormat = null;
            TemplateVariableType type = variable.getVariableType();
            List params = type.getParams();
            if (params.size() == 1) {
                this.fFormat = params.get(0).toString();
            }
            super.resolve(variable, context);
        }

        protected String resolve(TemplateContext context) {
            Object f = this.fFormat == null ? DateFormat.getDateInstance() : new SimpleDateFormat(this.fFormat);
            return f.format(new Date());
        }
    }

    static class FileTemplateVariableResolver
    extends SimpleTemplateVariableResolver {
        public FileTemplateVariableResolver(String type, String description) {
            super(type, description);
        }

        protected String resolve(TemplateContext context) {
            String value = context.getVariable(this.getType());
            return value != null ? value : "";
        }
    }
}

