/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;

public class AbstractTestingEngineValidateVisitor
extends ASTVisitor {
    private final Stack stack = new Stack();

    protected boolean isMethodCall(CallExpression call, String[] methods) {
        if (call.getReceiver() != null) {
            return false;
        }
        String methodName = call.getName();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isNodeOnStack(Class nodeClass) {
        int i = this.stack.size();
        while (--i >= 0) {
            if (!nodeClass.isAssignableFrom(this.stack.get(i).getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        this.stack.push(node);
        return super.visitGeneral(node);
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        this.stack.pop();
        super.endvisitGeneral(node);
    }

    protected boolean isMethodPrefix(MethodDeclaration method, String prefix) {
        String methodName = method.getName();
        return methodName.startsWith(prefix) && methodName.length() > prefix.length();
    }

    protected boolean isSuperClassOf(ISourceModule module, RubyClassDeclaration declaration, String className) {
        if (declaration.getSuperClassNames().contains(className)) {
            return true;
        }
        String classKey = className.replaceAll("::", String.valueOf('{'));
        HashSet<String> processedKeys = new HashSet<String>();
        Iterator iter = declaration.getSuperClassNames().iterator();
        while (iter.hasNext()) {
            String superClass = (String)iter.next();
            RubyMixinModel model = RubyMixinModel.getInstance((IScriptProject)module.getScriptProject());
            RubyMixinClass mixinClass = model.createRubyClass(new RubyClassType(superClass.replaceAll("::", String.valueOf('{'))));
            if (mixinClass != null) {
                mixinClass = mixinClass.getSuperclass();
            }
            while (mixinClass != null) {
                if (processedKeys.add(mixinClass.getKey())) {
                    if (mixinClass.getKey().equals(classKey)) {
                        return true;
                    }
                    mixinClass = mixinClass.getSuperclass();
                    continue;
                }
                mixinClass = null;
            }
        }
        return false;
    }

    private boolean isRequire(CallExpression call) {
        return call.getReceiver() == null && "require".equals(call.getName()) && call.getArgs().getChilds().size() == 1;
    }

    protected boolean isRequire(CallExpression call, String moduleName) {
        if (this.isRequire(call)) {
            ASTNode argument = (ASTNode)call.getArgs().getChilds().get(0);
            return this.isStringLiteralArgument(argument, moduleName);
        }
        return false;
    }

    protected boolean isStringLiteralArgument(ASTNode argument, String value) {
        StringLiteral literal;
        RubyCallArgument callArg;
        return argument instanceof RubyCallArgument && (callArg = (RubyCallArgument)argument).getValue() instanceof StringLiteral && value.equals((literal = (StringLiteral)callArg.getValue()).getValue());
    }
}

