/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.core.util.Util;

public class PersistentTimeStampMap {
    private Hashtable timestamps = null;
    private File file;

    public PersistentTimeStampMap(File timestampsFile) {
        this.file = timestampsFile;
    }

    public void save() throws CoreException {
        if (this.timestamps != null) {
            this.saveTimeStamps(this.timestamps, this.file);
        }
    }

    public Hashtable getTimestamps() {
        if (this.timestamps == null) {
            this.timestamps = this.readTimeStamps(this.file);
        }
        return this.timestamps;
    }

    private Hashtable readTimeStamps(File timestampsFile) {
        Hashtable<IPath, Long> timeStamps;
        block16: {
            timeStamps = new Hashtable<IPath, Long>();
            FilterInputStream in = null;
            try {
                try {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(timestampsFile)));
                    int size = ((DataInputStream)in).readInt();
                    while (size-- > 0) {
                        String key = ((DataInputStream)in).readUTF();
                        long timestamp = ((DataInputStream)in).readLong();
                        timeStamps.put(Path.fromPortableString((String)key), new Long(timestamp));
                    }
                }
                catch (IOException e) {
                    if (timestampsFile.exists()) {
                        Util.log(e, "Unable to read external time stamps");
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return timeStamps;
    }

    private void saveTimeStamps(Hashtable stamps, File timestamps) throws CoreException {
        if (stamps == null) {
            return;
        }
        FilterOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(timestamps)));
                ((DataOutputStream)out).writeInt(stamps.size());
                for (IPath key : stamps.keySet()) {
                    ((DataOutputStream)out).writeUTF(key.toPortableString());
                    Long timestamp = (Long)stamps.get(key);
                    ((DataOutputStream)out).writeLong(timestamp);
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.dltk.core", 4, "Problems while saving timestamps", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

