/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.ui.text;

import java.util.regex.Pattern;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.python.internal.ui.text.PythonPartitionScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class PythonAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    IPreferenceStore fStore;
    String fPartitioning;
    final int maxCharsAway = 100;

    public PythonAutoEditStrategy(IPreferenceStore store, String part) {
        this.fStore = store;
        this.fPartitioning = part;
    }

    private boolean isSmartTab() {
        return this.fStore.getBoolean("smart_tab");
    }

    private boolean isSmartMode() {
        return this.fStore.getBoolean("editorSmartIndent");
    }

    private boolean closeBrackets() {
        return this.fStore.getBoolean("closeBrackets");
    }

    private boolean isSmartPaste() {
        return this.fStore.getBoolean("smartPaste");
    }

    private boolean closeStrings() {
        return this.fStore.getBoolean("closeStrings");
    }

    private int getIndentSize() {
        return this.fStore.getInt("formatter.indentation.size");
    }

    private String getTabStyle() {
        return this.fStore.getString("formatter.tabulation.char");
    }

    private String getIndent() {
        if (this.getTabStyle().equals("space")) {
            int size = this.getIndentSize();
            String res = "";
            int i = 0;
            while (i < size) {
                res = String.valueOf(res) + " ";
                ++i;
            }
            return res;
        }
        return "\t";
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private String getLineIndent(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    public String getLineIndent(String line) {
        int end;
        int whiteend = end = line.length();
        int offset = 0;
        while (offset < end) {
            char c = line.charAt(offset);
            if (c != ' ' && c != '\t') {
                whiteend = offset;
                break;
            }
            ++offset;
        }
        return line.substring(0, whiteend);
    }

    private int getLastNonEmptyLine(IDocument d, int line) throws BadLocationException {
        int res = line;
        while (res > -1) {
            String str = this.getDocumentLine(d, res).trim();
            if (!str.startsWith("#") && str.length() > 0) {
                return res;
            }
            --res;
        }
        return res;
    }

    public String getDocumentLine(IDocument d, int line) throws BadLocationException {
        int start = d.getLineOffset(line);
        int length = d.getLineLength(line);
        return d.get(start, length);
    }

    private String getRegionType(IDocument d, int offset) throws BadLocationException {
        int p = offset == d.getLength() ? offset - 1 : offset;
        ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)p, (boolean)true);
        return region.getType();
    }

    /*
     * Unable to fully structure code
     */
    private int searchPair(IDocument d, int offset, boolean forward, char opening, char closing, boolean skipCommentLines, boolean skipStrings) throws BadLocationException {
        block12: {
            deep = 0;
            i = offset;
            if (!forward) ** GOTO lbl38
            while (i < d.getLength()) {
                region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)i, (boolean)true);
                if (region.getType() == "__python_comment" && skipCommentLines) {
                    i = region.getOffset() + region.getLength();
                    continue;
                }
                if (region.getType() == "__python_string" && skipStrings) {
                    i = region.getOffset() + region.getLength();
                    continue;
                }
                c = d.getChar(i);
                if (c == opening) {
                    ++deep;
                }
                if (c == closing) {
                    if (deep == 0) {
                        return i;
                    }
                    --deep;
                }
                if (++i - offset <= 100) continue;
                return -1;
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)i, (boolean)true);
                if (region.getType() == "__python_comment" && skipCommentLines) {
                    i = region.getOffset() - 1;
                    continue;
                }
                if (region.getType() == "__python_string" && skipStrings) {
                    i = region.getOffset() - 1;
                    continue;
                }
                c = d.getChar(i);
                if (c == closing) {
                    ++deep;
                }
                if (c == opening) {
                    if (deep == 0) {
                        return i;
                    }
                    --deep;
                }
                if (offset - --i <= 100) continue;
                return -1;
lbl38:
                // 4 sources

                ** while (i >= 0)
            }
        }
        return -1;
    }

    private int findIndentStart(IDocument d, int line) throws BadLocationException {
        String curIndent = this.getLineIndent(d, line);
        int curIndentLength = this.getPhysicalLength(curIndent);
        int cur = line - 1;
        while (cur >= 0) {
            String curLine = this.getDocumentLine(d, cur);
            String ind = this.getLineIndent(d, cur);
            if (!curLine.trim().startsWith("#") && this.getPhysicalLength(ind) < curIndentLength) {
                return cur;
            }
            --cur;
        }
        return line;
    }

    public int getPhysicalLength(String str) {
        int res = 0;
        int i = 0;
        while (i < str.length()) {
            res = str.charAt(i) == '\t' ? (res += 8) : ++res;
            ++i;
        }
        return res;
    }

    private char getBracePair(char b) {
        switch (b) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return b;
    }

    private static void installStuff(Document document) {
        String[] types = new String[]{"__python_string", "__python_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PythonPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__python_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeStuff(Document document) {
        document.setDocumentPartitioner("__python_partitioning", null);
    }

    private String calcLineIndent(IDocument d, int line, boolean newLine, int offset) throws BadLocationException {
        String curLine;
        String plineTrimmed;
        int pairOffset;
        String previousLineIndent;
        int lastNonEmptyLine;
        boolean isDocumentEnd;
        block40: {
            int plnumstart;
            String previousLine;
            int realLine;
            boolean bl = isDocumentEnd = offset == d.getLength();
            if (newLine) {
                if (this.getRegionType(d, offset) == "__python_string") {
                    realLine = d.getLineOfOffset(offset);
                    String curIndent = this.getLineIndent(d, realLine);
                    if (d.getChar(offset - 1) != '\"') {
                        if (this.getRegionType(d, d.getLineOffset(realLine)) == "__python_string") {
                            return curIndent;
                        }
                        return String.valueOf(curIndent) + this.getIndent();
                    }
                }
            } else if (this.getRegionType(d, d.getLineOffset(line)) == "__python_string") {
                return this.getLineIndent(d, line);
            }
            if (newLine) {
                realLine = d.getLineOfOffset(offset);
                if (line > 0) {
                    String prePreviousLine;
                    String previousLine2 = "";
                    if (realLine == line - 1) {
                        int start = d.getLineOffset(realLine);
                        previousLine2 = d.get(start, offset - start);
                    } else {
                        previousLine2 = this.getDocumentLine(d, line - 1);
                    }
                    if (previousLine2.trim().endsWith("\\")) {
                        String prePreviousLine2 = this.getDocumentLine(d, line - 2);
                        if (prePreviousLine2.trim().endsWith("\\")) {
                            return this.getLineIndent(d, line - 1);
                        }
                        return String.valueOf(this.getLineIndent(d, line - 1)) + this.getIndent() + this.getIndent();
                    }
                    if (line > 1 && (prePreviousLine = this.getDocumentLine(d, line - 2)).trim().endsWith("\\")) {
                        int t = line - 2;
                        while (t > 0 && this.getDocumentLine(d, t - 1).trim().endsWith("\\")) {
                            --t;
                        }
                        return this.getLineIndent(d, t);
                    }
                }
            } else if (line > 0 && (previousLine = this.getDocumentLine(d, line - 1)).trim().endsWith("\\")) {
                String prePreviousLine;
                if (line > 1 && (prePreviousLine = this.getDocumentLine(d, line - 2)).trim().endsWith("\\")) {
                    return this.getLineIndent(d, line - 1);
                }
                return String.valueOf(this.getLineIndent(d, line - 1)) + this.getIndent() + this.getIndent();
            }
            if ((lastNonEmptyLine = this.getLastNonEmptyLine(d, line - 1)) < 0) {
                return "";
            }
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)d.getLineOffset(lastNonEmptyLine), (boolean)true);
            if (region.getType() == "__python_string") {
                lastNonEmptyLine = d.getLineOfOffset(region.getOffset());
            }
            previousLineIndent = "";
            pairOffset = this.searchPair(d, d.getLineOffset(lastNonEmptyLine), false, '(', ')', true, true);
            if (pairOffset >= 0) {
                plnumstart = d.getLineOfOffset(pairOffset);
                previousLineIndent = this.getLineIndent(d, plnumstart);
            } else {
                plnumstart = lastNonEmptyLine;
                previousLineIndent = this.getLineIndent(d, lastNonEmptyLine);
            }
            int p = this.searchPair(d, offset - 1, false, '(', ')', true, true);
            if (p >= 0) {
                if (d.getLineOfOffset(p) == lastNonEmptyLine) {
                    int pp = this.searchPair(d, p, false, '(', ')', true, true);
                    if (pp >= 0) {
                        return String.valueOf(this.getLineIndent(d, lastNonEmptyLine)) + this.getIndent();
                    }
                    return String.valueOf(this.getLineIndent(d, lastNonEmptyLine)) + this.getIndent() + this.getIndent();
                }
                if (d.getLineOfOffset(p) == plnumstart) {
                    return this.getLineIndent(d, lastNonEmptyLine);
                }
                if (d.getLineOfOffset(p) == line && !newLine) {
                    return null;
                }
                return previousLineIndent;
            }
            String pline = "";
            pline = lastNonEmptyLine == line - 1 && newLine ? d.get(d.getLineOffset(line - 1), offset - d.getLineOffset(line - 1)) : this.getDocumentLine(d, lastNonEmptyLine);
            int plineLen = pline.length();
            int i = 0;
            while (i < plineLen) {
                if (pline.charAt(i) == '#') {
                    pline = pline.substring(0, i);
                    break;
                }
                ++i;
            }
            plineTrimmed = pline.trim();
            try {
                curLine = "";
                curLine = lastNonEmptyLine == line - 1 && newLine ? d.get(offset, d.getLineLength(line - 1) + d.getLineOffset(line - 1) - offset) : this.getDocumentLine(d, line).trim();
                if (!curLine.startsWith("except") && !curLine.startsWith("finally")) break block40;
                int lnum = line - 1;
                while (lnum >= 0) {
                    String temp = this.getDocumentLine(d, lnum).trim();
                    if (temp.startsWith("try") || temp.startsWith("except")) {
                        String ind = this.getLineIndent(d, lnum);
                        return ind;
                    }
                    --lnum;
                }
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        if (curLine.startsWith("elif") || curLine.startsWith("else")) {
            String temp = this.getDocumentLine(d, lastNonEmptyLine).trim();
            if (temp.startsWith("for") || temp.startsWith("if") || temp.startsWith("try") || temp.startsWith("while")) {
                return previousLineIndent;
            }
            int sline = this.findIndentStart(d, lastNonEmptyLine);
            String reqIndent = this.getLineIndent(d, sline);
            return reqIndent;
        }
        String regex = "^\\s*(break|continue|raise|pass|return)(\\s+.*$|$)";
        if (Pattern.matches(regex, plineTrimmed)) {
            int sline = this.findIndentStart(d, lastNonEmptyLine);
            String reqIndent = this.getLineIndent(d, sline);
            if (newLine || isDocumentEnd || this.getPhysicalLength(this.getLineIndent(d, line)) > this.getPhysicalLength(reqIndent)) {
                return reqIndent;
            }
            return null;
        }
        if (plineTrimmed.endsWith(":")) {
            return String.valueOf(previousLineIndent) + this.getIndent();
        }
        if (pairOffset >= 0 && newLine) {
            return previousLineIndent;
        }
        int prevLine = this.getLastNonEmptyLine(d, line - 1);
        if (this.getRegionType(d, d.getLineOffset(prevLine)) == "__python_string") {
            return previousLineIndent;
        }
        return null;
    }

    private void reindent(IDocument d, DocumentCommand c) {
        try {
            if (this.getRegionType(d, c.offset) != "__dftl_partition_content_type") {
                return;
            }
            int line = d.getLineOfOffset(c.offset);
            String newIndent = this.calcLineIndent(d, line, false, c.offset);
            if (newIndent == null) {
                return;
            }
            String curIndent = this.getLineIndent(d, line);
            if (this.getPhysicalLength(curIndent) < this.getPhysicalLength(newIndent)) {
                return;
            }
            d.replace(d.getLineOffset(line), curIndent.length(), newIndent);
            c.offset += newIndent.length() - curIndent.length();
        }
        catch (BadLocationException badLocationException) {}
    }

    /*
     * Exception decompiling
     */
    private void autoClose(IDocument d, DocumentCommand c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean smartIndentJump(IDocument d, DocumentCommand c) {
        String resultIndent;
        int line;
        block14: {
            String currentIndent;
            int start;
            block13: {
                block12: {
                    if (c.offset == -1 || d.getLength() == 0) {
                        return false;
                    }
                    try {
                        line = d.getLineOfOffset(c.offset);
                        start = d.getLineOffset(line);
                        resultIndent = this.calcLineIndent(d, line, false, start);
                        currentIndent = this.getLineIndent(d, line);
                        if (resultIndent != null) break block12;
                        String curLine = this.getDocumentLine(d, line);
                        if (curLine.trim().length() > 0) {
                            resultIndent = currentIndent;
                            break block12;
                        }
                        int pl = this.getLastNonEmptyLine(d, line - 1);
                        if (pl >= 0) {
                            String plStr = this.getDocumentLine(d, pl).trim();
                            String regex = "^\\s*(break|continue|raise|pass|return)(\\s+.*$|$)";
                            if (plStr.endsWith(":")) {
                                resultIndent = String.valueOf(this.getLineIndent(plStr)) + this.getIndent();
                            } else if (Pattern.matches(regex, plStr)) {
                                int sline = this.findIndentStart(d, pl);
                                resultIndent = this.getLineIndent(d, sline);
                            } else {
                                resultIndent = this.getLineIndent(d, pl);
                            }
                            break block12;
                        }
                        return false;
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (c.offset < start + resultIndent.length()) break block13;
                return false;
            }
            if (currentIndent.startsWith(resultIndent)) break block14;
            c.offset = start;
            c.length = currentIndent.length();
            c.shiftsCaret = false;
            c.text = resultIndent;
            c.caretOffset = d.getLineOffset(line) + resultIndent.length();
            return true;
        }
        c.length = 0;
        c.shiftsCaret = false;
        c.text = "";
        c.caretOffset = d.getLineOffset(line) + resultIndent.length();
        return true;
    }

    private void smartPaste(IDocument d, DocumentCommand c) {
        try {
            String content = String.valueOf(d.get(0, c.offset)) + c.text;
            Document temp = new Document(content);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            PythonAutoEditStrategy.installStuff(temp);
            int offset = c.offset;
            int line = temp.getLineOfOffset(offset);
            String lastIndent = this.getLineIndent((IDocument)temp, line);
            int firstLineOffset = temp.getLineOffset(line);
            String commonIndent = temp.get(firstLineOffset, c.offset - firstLineOffset);
            ++line;
            try {
                while (this.getDocumentLine((IDocument)temp, line).trim().length() == 0) {
                    ++line;
                }
                offset = temp.getLineOffset(line);
            }
            catch (BadLocationException badLocationException) {
                offset = temp.getLength();
            }
            while (offset < temp.getLength()) {
                String resultIndent = this.calcLineIndent((IDocument)temp, line, false, temp.getLineOffset(line));
                String currentIndent = this.getLineIndent((IDocument)temp, line);
                if (resultIndent == null && this.getPhysicalLength(resultIndent = String.valueOf(commonIndent) + currentIndent) > this.getPhysicalLength(lastIndent)) {
                    resultIndent = lastIndent;
                }
                temp.replace(offset, currentIndent.length(), resultIndent);
                String currentLine = this.getDocumentLine((IDocument)temp, line);
                if (currentLine.trim().length() > 0 && !currentLine.trim().startsWith("#")) {
                    lastIndent = resultIndent;
                }
                if (temp.getLineOffset(line) + temp.getLineLength(line) == temp.getLength()) break;
                offset = temp.getLineOffset(++line);
            }
            temp.stopRewriteSession(session);
            PythonAutoEditStrategy.removeStuff(temp);
            c.text = temp.get(c.offset, temp.getLength() - c.offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        block18: {
            block17: {
                if (!c.doit) {
                    return;
                }
                if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
                    if (!this.isSmartMode()) {
                        super.customizeDocumentCommand(d, c);
                        return;
                    }
                    try {
                        String indent = this.calcLineIndent(d, d.getLineOfOffset(c.offset) + 1, true, c.offset);
                        if (indent == null) {
                            super.customizeDocumentCommand(d, c);
                        } else {
                            if (DLTKCore.DEBUG) {
                                System.err.println("Bug:PTN-9");
                            }
                            c.text = String.valueOf(c.text) + indent;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        super.customizeDocumentCommand(d, c);
                    }
                    return;
                }
                if (c.length > 1 || c.text.length() != 1) break block17;
                switch (c.text.charAt(0)) {
                    case ':': {
                        this.reindent(d, c);
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.autoClose(d, c);
                        break;
                    }
                    case '\t': {
                        boolean jumped = false;
                        if (this.isSmartTab()) {
                            jumped = this.smartIndentJump(d, c);
                        }
                        if (jumped) break block18;
                        c.text = this.getIndent();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block18;
            }
            if (c.text.length() >= 1 && this.isSmartPaste()) {
                this.smartPaste(d, c);
            }
        }
    }
}

