/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBlockWithBeginEndNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracesConfiguration;

public class BracesNode
extends FormatterBlockWithBeginEndNode {
    private IBracesConfiguration configuration;

    public BracesNode(IFormatterDocument document, IBracesConfiguration configuration) {
        super(document);
        Assert.isNotNull((Object)configuration);
        this.configuration = configuration;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        context.setBlankLines(this.getBlankLinesBefore(context));
        this.printBeforeOpenBrace(context, visitor);
        if (this.configuration.isBracesIndenting()) {
            context.incIndent();
        }
        if (this.getBegin() != null) {
            IFormatterTextNode[] nodes = this.getBegin();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept(context, visitor);
                ++i;
            }
        }
        this.printAfterOpenBrace(context, visitor);
        this.acceptBody(context, visitor);
        this.printBeforeCloseBrace(context, visitor);
        if (this.getEnd() != null) {
            visitor.write(context, this.getEnd().getStartOffset(), this.getEnd().getEndOffset());
        }
        this.printAfterCloseBrace(context, visitor);
        if (this.configuration.isBracesIndenting()) {
            context.decIndent();
        }
    }

    private void printBeforeCloseBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertBeforeCloseBrace()) {
            case 2: {
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    private void printAfterOpenBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertAfterOpenBrace()) {
            case 2: {
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
                break;
            }
            default: {
                if (this.configuration.insertBeforeOpenBrace() == 2) break;
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    private void printBeforeOpenBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertBeforeOpenBrace()) {
            case 2: {
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    private void printAfterCloseBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertAfterCloseBrace()) {
            case 2: {
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    protected void acceptNodes(List nodes, IFormatterContext context, IFormatterWriter visitor) throws Exception {
        if (this.isIndenting()) {
            context.incIndent();
        }
        super.acceptNodes(nodes, context, visitor);
        if (this.isIndenting()) {
            context.decIndent();
        }
    }

    protected boolean isIndenting() {
        return this.configuration.isIndenting();
    }
}

