/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Keyword;

public class VariableDeclaration
extends Expression {
    private Keyword varKeyword;
    private List variables;
    private List commas;

    public VariableDeclaration(ASTNode parent) {
        super(parent);
    }

    public List getVariables() {
        return this.variables;
    }

    public void setVariables(List variables) {
        this.variables = variables;
    }

    public Keyword getVarKeyword() {
        return this.varKeyword;
    }

    public void setVarKeyword(Keyword keyword) {
        this.varKeyword = keyword;
    }

    public List getCommas() {
        return this.commas;
    }

    public void setCommas(List commas) {
        this.commas = commas;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.variables.size() == 0 || this.commas.size() == this.variables.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("var");
        buffer.append(" ");
        int i = 0;
        while (i < this.variables.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(((ISourceable)this.variables.get(i)).toSourceString(indentationString));
            ++i;
        }
        return buffer.toString();
    }

    public boolean isBlock() {
        return false;
    }
}

