/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.Statement;

public class LabelledStatement
extends Statement {
    private Label label;
    private int colon = -1;
    private Statement statement;

    public LabelledStatement(ASTNode parent) {
        super(parent);
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public int getColonPosition() {
        return this.colon;
    }

    public void setColonPosition(int colon) {
        this.colon = colon;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.colon > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append(this.getLabel().toSourceString(indentationString));
        buffer.append(":\n");
        buffer.append(this.getStatement().toSourceString(String.valueOf(indentationString) + "    "));
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

