/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpIOException;
import org.eclipse.dltk.dbgp.exceptions.DbgpOpertionCanceledException;
import org.eclipse.dltk.dbgp.exceptions.DbgpTimeoutException;
import org.eclipse.dltk.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.DebugOption;
import org.eclipse.dltk.debug.core.IDebugOptions;
import org.w3c.dom.Element;

public class DbgpDebuggingEngineCommunicator
implements IDbgpCommunicator {
    private final int timeout;
    private final IDbgpDebugingEngine engine;
    private IDebugOptions options;
    private final Map activeRequests = new IdentityHashMap();
    private static final boolean DEBUG = false;

    private void sendRequest(DbgpRequest command) throws IOException {
        this.engine.sendCommand(command);
    }

    private DbgpResponsePacket receiveResponse(int transactionId) throws IOException, InterruptedException {
        return this.engine.getResponsePacket(transactionId, this.timeout);
    }

    public DbgpDebuggingEngineCommunicator(IDbgpDebugingEngine engine, IDebugOptions options) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        this.options = options;
        this.timeout = DLTKDebugPlugin.getDefault().getPluginPreferences().getInt("dbgp_response_timeout");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element communicate(DbgpRequest request) throws DbgpException {
        try {
            DbgpResponsePacket packet;
            int requestId = Integer.parseInt(request.getOption("-i"));
            if (this.options.get(DebugOption.DBGP_ASYNC) || request.isAsync()) {
                this.sendRequest(request);
                packet = this.receiveResponse(requestId);
            } else {
                this.beginSyncRequest(request);
                try {
                    this.sendRequest(request);
                    packet = this.receiveResponse(requestId);
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.endSyncRequest(request);
                    throw throwable;
                }
                {
                    Object var4_9 = null;
                    this.endSyncRequest(request);
                }
            }
            if (packet == null) {
                throw new DbgpTimeoutException();
            }
            Element response = packet.getContent();
            DbgpDebuggingEngineException e = DbgpXmlParser.checkError(response);
            if (e != null) {
                throw e;
            }
            return response;
        }
        catch (InterruptedException e) {
            throw new DbgpOpertionCanceledException(e);
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endSyncRequest(DbgpRequest request) {
        Map map = this.activeRequests;
        synchronized (map) {
            this.activeRequests.remove(request);
            this.activeRequests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginSyncRequest(DbgpRequest request) throws InterruptedException {
        Map map = this.activeRequests;
        synchronized (map) {
            while (!this.activeRequests.isEmpty()) {
                this.activeRequests.wait();
            }
            this.activeRequests.put(request, request);
        }
    }

    public void send(DbgpRequest request) throws DbgpException {
        try {
            this.sendRequest(request);
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    public IDebugOptions getDebugOptions() {
        return this.options;
    }

    public void configure(IDebugOptions debugOptions) {
        this.options = debugOptions;
    }
}

