/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.utils.CorePrinter;

public class RubyColonExpression
extends ASTNode {
    private final ASTNode left;
    private final String name;

    public ASTNode getLeft() {
        return this.left;
    }

    public String getName() {
        return this.name;
    }

    public RubyColonExpression(String name, ASTNode left) {
        this.name = name;
        this.left = left;
    }

    public int getKind() {
        return 0;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.left != null) {
                this.left.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public boolean isFull() {
        return this.left == null;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("ColonExpression" + this.getSourceRange().toString() + ":");
        output.indent();
        if (this.isFull()) {
            output.formatPrint("::");
        }
        if (this.left != null) {
            this.left.printNode(output);
        }
        output.formatPrint(this.getName());
        output.dedent();
    }
}

