/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal.testunit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.corext.SourceRange;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.debug.ui.console.RubyConsoleSourceModuleLookup;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestRunnerUI;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestingEngine;
import org.eclipse.dltk.ruby.testing.internal.AbstractTestingEngineValidateVisitor;
import org.eclipse.dltk.ruby.testing.internal.ResolverUtils;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingPlugin;
import org.eclipse.dltk.ruby.testing.internal.testunit.ShouldaUtils;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.TestElementResolution;
import org.eclipse.dltk.testing.model.ITestCaseElement;
import org.eclipse.dltk.testing.model.ITestSuiteElement;
import org.eclipse.osgi.util.NLS;

public class TestUnitTestRunnerUI
extends AbstractRubyTestRunnerUI {
    private static final char CLASS_BEGIN = '(';
    private static final char CLASS_END = ')';
    private static final String SHOULDA_TEST_PREFIX = "test:";
    private static final String[] TEST_UNIT = new String[]{"test", "unit"};
    private static final Pattern GEM_SHOULDA_LIB = Pattern.compile(TestUnitTestRunnerUI.buildRegex());

    public TestUnitTestRunnerUI(AbstractRubyTestingEngine testingEngine, IScriptProject project) {
        super(testingEngine, project);
    }

    public String getTestCaseLabel(ITestCaseElement caseElement, boolean full) {
        String testName = caseElement.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            int braceIndex = index;
            while (index > 0 && Character.isWhitespace(testName.charAt(index - 1))) {
                --index;
            }
            if (full) {
                int end = testName.length();
                if (end > braceIndex + 1 && testName.charAt(end - 1) == ')') {
                    --end;
                }
                String template = DLTKTestingMessages.TestSessionLabelProvider_testMethodName_className;
                return NLS.bind((String)template, (Object)testName.substring(braceIndex + 1, end), (Object)testName.substring(0, index));
            }
            return testName.substring(0, index);
        }
        return testName;
    }

    public String getTestStartedMessage(ITestCaseElement caseElement) {
        String testName = caseElement.getTestName();
        int index = testName.lastIndexOf(40);
        if (index > 0) {
            int end = testName.length();
            if (end > index && testName.charAt(end - 1) == ')') {
                --end;
            }
            String className = testName.substring(index + 1, end);
            while (index > 0 && Character.isWhitespace(testName.charAt(index - 1))) {
                --index;
            }
            String method = testName.substring(0, index);
            return NLS.bind((String)DLTKTestingMessages.TestRunnerViewPart_message_started, (Object)className, (Object)method);
        }
        return testName;
    }

    protected TestElementResolution resolveTestCase(ITestCaseElement testCase) {
        IMethod method;
        String testName = testCase.getTestName();
        if (testName.length() == 0) {
            return null;
        }
        int pos = testName.lastIndexOf(40);
        if (pos <= 0 || testName.charAt(testName.length() - 1) != ')') {
            return null;
        }
        String className = testName.substring(pos + 1, testName.length() - 1);
        if (!RubySyntaxUtils.isValidClass((String)className)) {
            return null;
        }
        String methodName = testName.substring(0, pos).trim();
        if (RubySyntaxUtils.isRubyMethodName((String)methodName) && (method = this.findMethod(className, methodName)) != null) {
            return new TestElementResolution((IModelElement)method, ResolverUtils.getSourceRange((IMember)method));
        }
        List types = this.findClasses(className);
        if (types == null) {
            return null;
        }
        if (methodName.startsWith(SHOULDA_TEST_PREFIX)) {
            String shouldName = methodName.substring(SHOULDA_TEST_PREFIX.length()).trim();
            if (shouldName.length() != 0 && shouldName.charAt(shouldName.length() - 1) == '.') {
                shouldName = shouldName.substring(0, shouldName.length() - 1).trim();
            }
            if (shouldName.length() != 0) {
                HashSet<IResource> resources = new HashSet<IResource>();
                Iterator i = types.iterator();
                while (i.hasNext()) {
                    IType type = (IType)i.next();
                    IResource resource = type.getResource();
                    if (resource == null || !(resource instanceof IFile)) continue;
                    resources.add(resource);
                }
                if (resources.isEmpty()) {
                    return null;
                }
                i = resources.iterator();
                while (i.hasNext()) {
                    ISourceModule module = (ISourceModule)DLTKCore.create((IFile)((IFile)i.next()));
                    TestElementResolution resolution = this.findShould(module, className, shouldName);
                    if (resolution == null) continue;
                    return resolution;
                }
            }
        }
        return null;
    }

    private TestElementResolution findShould(ISourceModule module, String className, String shouldName) {
        ModuleDeclaration declaration = ResolverUtils.parse(module);
        if (declaration != null) {
            try {
                ShouldLocator locator = new ShouldLocator(className, shouldName);
                declaration.traverse((ASTVisitor)locator);
                if (locator.range != null) {
                    ISourceRange range = ResolverUtils.adjustRange(module.getSource(), locator.range);
                    return new TestElementResolution((IModelElement)module, range);
                }
            }
            catch (Exception e) {
                RubyTestingPlugin.error("Error in findShould()", e);
            }
        }
        return null;
    }

    protected TestElementResolution resolveTestSuite(ITestSuiteElement element) {
        List types;
        String className = element.getSuiteTypeName();
        if (RubySyntaxUtils.isValidClass((String)className) && (types = this.findClasses(className)) != null) {
            IType type = (IType)types.get(0);
            return new TestElementResolution((IModelElement)type, ResolverUtils.getSourceRange((IMember)type));
        }
        return null;
    }

    private IMethod findMethod(String className, String methodName) {
        IDLTKSearchScope scope = this.getSearchScope();
        String sPattern = String.valueOf(className) + "::" + methodName;
        SearchPattern pattern = SearchPattern.createPattern((String)sPattern, (int)1, (int)0, (int)8, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        try {
            MethodRequestor requestor = new MethodRequestor();
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
            return requestor.method;
        }
        catch (CoreException e) {
            RubyTestingPlugin.error(NLS.bind((String)"Error in findMethod({0}::{1})", (Object)className, (Object)methodName), e);
            return null;
        }
    }

    private List findClasses(String className) {
        IDLTKSearchScope scope = this.getSearchScope();
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)8, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        try {
            TypeSearchRequestor requestor = new TypeSearchRequestor();
            new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
            if (!requestor.types.isEmpty()) {
                return requestor.types;
            }
        }
        catch (CoreException e) {
            RubyTestingPlugin.error(NLS.bind((String)"Error in findClasses({0})", (Object)className), e);
        }
        return null;
    }

    private boolean testFragmentPath(IPath fragmentPath, IPath path) {
        if (this.pathEquality.isPrefixOf(fragmentPath, path) && path.segmentCount() > fragmentPath.segmentCount() + TEST_UNIT.length) {
            int j = 0;
            while (j < TEST_UNIT.length) {
                if (!TEST_UNIT[j].equals(path.segment(fragmentPath.segmentCount() + j))) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private static String buildRegex() {
        return "[\\\\/]gems[\\\\/]Shoulda-[\\w\\.]+[\\\\/]lib[\\\\/]";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean selectLine(String line) {
        String filename = this.extractFileName(line);
        if (filename == null) {
            return true;
        }
        if (filename.endsWith("dltk-testunit-runner.rb")) {
            return false;
        }
        if (GEM_SHOULDA_LIB.matcher(filename).find()) {
            return false;
        }
        Path path = new Path(filename);
        try {
            IProjectFragment[] fragments = this.project.getProjectFragments();
            int i = 0;
            while (true) {
                if (i >= fragments.length) {
                    return true;
                }
                IProjectFragment fragment = fragments[i];
                if (fragment.isExternal() && this.testFragmentPath(EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()), (IPath)path) && RubyConsoleSourceModuleLookup.isIncluded((IProjectFragment)fragment, (IPath)path)) {
                    return false;
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return true;
        }
    }

    private static final class MethodRequestor
    extends SearchRequestor {
        IMethod method = null;

        private MethodRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.method = (IMethod)match.getElement();
        }
    }

    private static class ShouldLocator
    extends AbstractTestingEngineValidateVisitor {
        private static final String TWO_COLONS = "::";
        private final String className;
        private final String shouldName;
        private ISourceRange range = null;
        final Stack typeMatches = new Stack();
        final Stack calls = new Stack();

        public ShouldLocator(String className, String shouldName) {
            this.className = className;
            this.shouldName = shouldName;
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            String enclosingName = s.getEnclosingTypeName();
            String fullName = enclosingName.length() == 0 ? s.getName() : String.valueOf(enclosingName.replaceAll("\\$", TWO_COLONS)) + TWO_COLONS + s.getName();
            this.typeMatches.push(this.className.equals(fullName));
            return true;
        }

        public boolean endvisit(TypeDeclaration s) throws Exception {
            this.typeMatches.pop();
            return true;
        }

        private boolean isMatchedType() {
            int i = 0;
            int size = this.typeMatches.size();
            while (i < size) {
                Boolean value = (Boolean)this.typeMatches.get(i);
                if (value.booleanValue()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            RubyCallArgument callArg;
            Object arg0;
            CallExpression call;
            if (this.isMatchedType() && this.range == null && node instanceof CallExpression && this.isMethodCall(call = (CallExpression)node, ShouldaUtils.METHODS) && call.getArgs().getChilds().size() >= 1 && (arg0 = call.getArgs().getChilds().get(0)) instanceof RubyCallArgument && (callArg = (RubyCallArgument)arg0).getValue() instanceof StringLiteral) {
                this.calls.push(call);
                if (this.isShouldMatched()) {
                    this.range = new SourceRange(call.sourceStart(), callArg.sourceEnd() - call.sourceStart());
                }
            }
            return super.visitGeneral(node);
        }

        private boolean isShouldMatched() {
            if (this.isShouldMatched(this.shouldName)) {
                return true;
            }
            String noTestClassName = this.className.replaceAll("Test", "");
            if (this.startsWith(this.shouldName, noTestClassName)) {
                return this.isShouldMatched(this.shouldName.substring(noTestClassName.length()).trim());
            }
            return false;
        }

        private boolean startsWith(String value, String substring) {
            return value.length() > substring.length() && value.startsWith(substring) && Character.isWhitespace(value.charAt(substring.length()));
        }

        private boolean isShouldMatched(String value) {
            int i = 0;
            while (i < this.calls.size()) {
                RubyCallArgument callArg;
                String literal;
                CallExpression call = (CallExpression)this.calls.get(i);
                if ("should".equals(call.getName())) {
                    if (!this.startsWith(value, "should")) {
                        return false;
                    }
                    if ((value = value.substring("should".length()).trim()).equals(literal = ((StringLiteral)(callArg = (RubyCallArgument)call.getArgs().getChilds().get(0)).getValue()).getValue())) {
                        return true;
                    }
                } else if ("context".equals(call.getName())) {
                    callArg = (RubyCallArgument)call.getArgs().getChilds().get(0);
                    literal = ((StringLiteral)callArg.getValue()).getValue().trim();
                    if (!this.startsWith(value, literal)) {
                        return false;
                    }
                    value = value.substring(literal.length()).trim();
                }
                ++i;
            }
            return false;
        }

        public void endvisitGeneral(ASTNode node) throws Exception {
            if (!this.calls.isEmpty() && this.calls.peek() == node) {
                this.calls.pop();
            }
            super.endvisitGeneral(node);
        }
    }

    private static final class TypeSearchRequestor
    extends SearchRequestor {
        final List types = new ArrayList();

        private TypeSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.types.add(match.getElement());
        }
    }
}

