/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;

public class TryStatement
extends Statement {
    private Keyword tryKeyword;
    private StatementBlock body;
    private List catchClauses;
    private FinallyClause finallyClause;

    public TryStatement(ASTNode parent) {
        super(parent);
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    public FinallyClause getFinally() {
        return this.finallyClause;
    }

    public void setFinally(FinallyClause finallyClause) {
        this.finallyClause = finallyClause;
    }

    public List getCatches() {
        return this.catchClauses;
    }

    public void setCatches(List catches) {
        this.catchClauses = catches;
    }

    public Keyword getTryKeyword() {
        return this.tryKeyword;
    }

    public void setTryKeyword(Keyword keyword) {
        this.tryKeyword = keyword;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("try");
        buffer.append("\n");
        buffer.append(this.body.toSourceString(indentationString));
        int i = 0;
        while (i < this.getCatches().size()) {
            buffer.append(((ISourceable)this.getCatches().get(i)).toSourceString(indentationString));
            ++i;
        }
        if (this.getFinally() != null) {
            buffer.append(this.getFinally().toSourceString(indentationString));
        }
        return buffer.toString();
    }

    public boolean isBlock() {
        return true;
    }
}

