/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.core.SimpleDLTKExtensionManager;

public class ModelProviderManager {
    private static final String REQUIRES = "requires";
    private static final String ID = "id";
    private static final String LANGUAGE = "language";
    private static SimpleClassDLTKExtensionManager manager = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.core.model");
    private static Map providers = null;

    public static synchronized IModelProvider[] getProviders(String lang) {
        if (providers == null) {
            providers = new HashMap();
            SimpleDLTKExtensionManager.ElementInfo[] infos = manager.getElementInfos();
            HashMap langToElementList = new HashMap();
            int i = 0;
            while (i < infos.length) {
                List<SimpleDLTKExtensionManager.ElementInfo> elements;
                String langauge = infos[i].getConfig().getAttribute(LANGUAGE);
                if (langToElementList.containsKey(langauge)) {
                    elements = (List)langToElementList.get(langauge);
                    elements.add(infos[i]);
                } else {
                    elements = new ArrayList();
                    elements.add(infos[i]);
                    langToElementList.put(langauge, elements);
                }
                ++i;
            }
            for (Map.Entry entry : langToElementList.entrySet()) {
                String language = (String)entry.getKey();
                List elements = (List)entry.getValue();
                HashMap<String, SimpleDLTKExtensionManager.ElementInfo> names = new HashMap<String, SimpleDLTKExtensionManager.ElementInfo>();
                int i2 = 0;
                while (i2 < elements.size()) {
                    SimpleDLTKExtensionManager.ElementInfo info = (SimpleDLTKExtensionManager.ElementInfo)elements.get(i2);
                    String name = info.getConfig().getAttribute(ID);
                    names.put(name, info);
                    ++i2;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                HashSet<String> added = new HashSet<String>();
                ArrayList<SimpleDLTKExtensionManager.ElementInfo> toProcess = new ArrayList<SimpleDLTKExtensionManager.ElementInfo>();
                toProcess.addAll(elements);
                while (!toProcess.isEmpty()) {
                    SimpleDLTKExtensionManager.ElementInfo info = (SimpleDLTKExtensionManager.ElementInfo)toProcess.remove(0);
                    String requires = info.getConfig().getAttribute(REQUIRES);
                    if (requires == null) {
                        result.add(manager.getInitObject(info));
                        continue;
                    }
                    String req = requires.trim();
                    if (added.contains(req)) {
                        result.add(info.object);
                        continue;
                    }
                    if (names.containsKey(req)) {
                        toProcess.add(info);
                        added.add(info.getConfig().getAttribute(ID));
                        continue;
                    }
                    result.add(info.object);
                    added.add(info.getConfig().getAttribute(ID));
                }
                providers.put(language, result.toArray(new IModelProvider[result.size()]));
            }
        }
        return (IModelProvider[])providers.get(lang);
    }
}

