/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.search.indexing.core.IInternalMixinElement;
import org.eclipse.dltk.internal.core.OverflowingLRUCache;
import org.eclipse.dltk.internal.core.util.LRUCache;

public class StructureCache
extends OverflowingLRUCache {
    IMixinElement spaceLimitParent = null;

    public StructureCache(int size) {
        super(size);
        this.fLoadFactor = 0.9;
    }

    public StructureCache(int size, int overflow) {
        super(size, overflow);
    }

    protected boolean close(LRUCache.LRUCacheEntry entry) {
        IMixinElement element = (IMixinElement)entry._fValue;
        if (element instanceof IInternalMixinElement) {
            ((IInternalMixinElement)((Object)element)).close();
        }
        return true;
    }

    public void ensureSpaceLimit(int childrenSize, IMixinElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    protected LRUCache newInstance(int size, int overflow) {
        return new StructureCache(size, overflow);
    }

    public void resetSpaceLimit(int defaultLimit, IMixinElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }
}

