/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.core.util.Util;

public abstract class AbstractDataSaver {
    private static final int MAX_STR = 65500;
    protected OutputStream stream;
    protected DataOutputStream out;
    private List<String> stringIndex = new ArrayList<String>();
    private ByteArrayOutputStream bout;

    public AbstractDataSaver(OutputStream stream) {
        this.stream = stream;
        this.bout = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.bout);
    }

    protected void writeString(String value) throws IOException {
        if (value == null) {
            this.out.writeByte(0);
            return;
        }
        if (value.length() > 65500) {
            ArrayList<String> strs = new ArrayList<String>();
            int len = value.length();
            int pos = 0;
            while (len > 0) {
                if (len > 65500) {
                    len -= 65500;
                    strs.add(value.substring(pos, pos + 65500));
                    pos += 65500;
                    continue;
                }
                strs.add(value.substring(pos, pos + len));
                len = 0;
            }
            this.out.writeByte(4);
            this.out.writeInt(strs.size());
            for (String part : strs) {
                this.writeString(part);
            }
            return;
        }
        int indexOf = this.stringIndex.indexOf(value);
        if (indexOf != -1) {
            this.outNum(indexOf, 1, 2);
            return;
        }
        if (value.length() > 6) {
            for (String base : this.stringIndex) {
                if (!base.contains(value)) continue;
                int pos = base.indexOf(value);
                this.out.writeByte(3);
                int basePos = this.stringIndex.indexOf(base);
                this.outNum(basePos, 1, 2);
                this.outNum(pos, 1, 2);
                this.outNum(value.length(), 1, 2);
                return;
            }
        }
        this.stringIndex.add(value);
        this.outNum(this.stringIndex.size() - 1, 1, 2);
    }

    protected void outNum(int indexOf, int id1, int id2) throws IOException {
        if (indexOf <= 127) {
            this.out.writeByte(id1);
            this.out.writeByte(indexOf);
        } else if (indexOf > 127) {
            this.out.writeByte(id2);
            this.out.writeInt(indexOf);
        }
    }

    protected void storeStringIndex() throws IOException {
        this.out.flush();
        this.out = new DataOutputStream(this.stream);
        this.out.writeInt(this.stringIndex.size());
        for (String s : this.stringIndex) {
            Util.writeUTF(this.out, s.toCharArray());
        }
        org.eclipse.dltk.compiler.util.Util.copy(new ByteArrayInputStream(this.bout.toByteArray()), this.out);
    }
}

