/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.launching;

import java.util.List;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.launching.InterpreterConfig;

public class InterpreterConfigTests
extends AbstractModelTests {
    private static final String PROJECT_NAME = "launching";
    private IScriptProject scriptProject;
    static /* synthetic */ Class class$0;

    public InterpreterConfigTests(String name) {
        super("org.eclipse.dltk.core.tests", name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.scriptProject = this.setUpScriptProject(PROJECT_NAME);
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject(PROJECT_NAME);
        super.tearDownSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.tests.launching.InterpreterConfigTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite(clazz);
    }

    protected InterpreterConfig createInterperterConfig() {
        IProject project = this.scriptProject.getProject();
        IResource member = project.findMember("src/script.xxx");
        IPath scriptPath = member.getLocation();
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this.scriptProject);
        return new InterpreterConfig(env, scriptPath);
    }

    public void testInterpreterConfig() {
        IProject project = this.scriptProject.getProject();
        IResource member = project.findMember("src/script.xxx");
        IPath scriptPath = member.getLocation();
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)this.scriptProject);
        InterpreterConfig config = new InterpreterConfig(env, scriptPath);
        InterpreterConfigTests.assertNotNull((Object)config.getScriptFilePath());
        InterpreterConfigTests.assertNotNull((Object)config.getWorkingDirectoryPath());
        InterpreterConfigTests.assertEquals((String)scriptPath.toOSString(), (String)config.getScriptFilePath().toOSString());
        InterpreterConfigTests.assertEquals((String)scriptPath.removeLastSegments(1).toOSString(), (String)config.getWorkingDirectoryPath().toOSString());
        try {
            config.setScriptFile(null);
            InterpreterConfigTests.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            config.setWorkingDirectory(null);
            InterpreterConfigTests.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testInterpreterConfigEnvArgs() {
        InterpreterConfig config = this.createInterperterConfig();
        InterpreterConfigTests.assertEquals((int)0, (int)config.getEnvVars().size());
        InterpreterConfigTests.assertFalse((boolean)config.hasEnvVar("DIMAN"));
        InterpreterConfigTests.assertNull((Object)config.getEnvVar("KDS"));
        config.addEnvVar("KDS", "DIMAN");
        InterpreterConfigTests.assertTrue((boolean)config.hasEnvVar("KDS"));
        InterpreterConfigTests.assertNotNull((Object)config.getEnvVar("KDS"));
        InterpreterConfigTests.assertEquals((String)"DIMAN", (String)config.getEnvVar("KDS"));
        config.removeEnvVar("KDS");
        InterpreterConfigTests.assertFalse((boolean)config.hasEnvVar("DIMAN"));
        InterpreterConfigTests.assertNull((Object)config.getEnvVar("KDS"));
        InterpreterConfigTests.assertEquals((int)0, (int)config.getEnvVars().size());
        try {
            config.addEnvVar("KDS", null);
            InterpreterConfigTests.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            config.addEnvVar(null, "DIMAN");
            InterpreterConfigTests.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testInterperterConfigScriptArgs() {
        InterpreterConfig config = this.createInterperterConfig();
        InterpreterConfigTests.assertEquals((int)0, (int)config.getScriptArgs().size());
        InterpreterConfigTests.assertFalse((boolean)config.hasScriptArg("-gXXX"));
        config.addScriptArg("-gXXX");
        InterpreterConfigTests.assertTrue((boolean)config.hasScriptArg("-gXXX"));
        config.addScriptArg("-pXXX");
        InterpreterConfigTests.assertTrue((boolean)config.hasScriptArg("-pXXX"));
        List args = config.getScriptArgs();
        InterpreterConfigTests.assertEquals((int)2, (int)args.size());
        InterpreterConfigTests.assertEquals((Object)"-gXXX", args.get(0));
        InterpreterConfigTests.assertEquals((Object)"-pXXX", args.get(1));
        try {
            config.addScriptArg(null);
            InterpreterConfigTests.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testInterperterConfigInterpreterArgs() {
        InterpreterConfig config = this.createInterperterConfig();
        InterpreterConfigTests.assertEquals((int)0, (int)config.getInterpreterArgs().size());
        InterpreterConfigTests.assertFalse((boolean)config.hasInterpreterArg("arg1"));
        config.addInterpreterArg("arg1");
        InterpreterConfigTests.assertTrue((boolean)config.hasInterpreterArg("arg1"));
        config.addInterpreterArg("arg2");
        InterpreterConfigTests.assertTrue((boolean)config.hasInterpreterArg("arg2"));
        List args = config.getInterpreterArgs();
        InterpreterConfigTests.assertEquals((int)2, (int)args.size());
        InterpreterConfigTests.assertEquals((Object)"arg1", args.get(0));
        InterpreterConfigTests.assertEquals((Object)"arg2", args.get(1));
        try {
            config.addInterpreterArg(null);
            InterpreterConfigTests.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

