/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public final class TclCheckerMarker {
    public static final String PROBLEM_ID = "org.eclipse.dltk.tcl.tclchecker.tclcheckerproblem";

    private TclCheckerMarker() {
    }

    public static IMarker setMarker(IResource res, int line, int start, int end, String msg, int severity, int priority) throws CoreException {
        IMarker m = res.createMarker(PROBLEM_ID);
        m.setAttribute("lineNumber", line);
        m.setAttribute("message", (Object)msg);
        m.setAttribute("severity", severity);
        m.setAttribute("priority", priority);
        m.setAttribute("charStart", start);
        m.setAttribute("charEnd", end);
        return m;
    }

    public static void clearMarkers(IResource resource) throws CoreException {
        resource.deleteMarkers(PROBLEM_ID, true, 2);
    }

    public static void clearMarkers(IProject project) throws CoreException {
        ProblemRemover visitor = new ProblemRemover();
        project.accept((IResourceVisitor)visitor);
        if (visitor.hasErrors()) {
            throw visitor.getException();
        }
    }

    private static class ProblemRemover
    implements IResourceVisitor {
        private CoreException exception;

        public boolean hasErrors() {
            return this.exception != null;
        }

        public CoreException getException() {
            return this.exception;
        }

        public boolean visit(IResource resource) {
            try {
                TclCheckerMarker.clearMarkers(resource);
            }
            catch (CoreException e) {
                this.exception = e;
                return false;
            }
            return true;
        }
    }
}

