/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ui.tests.text;

import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.internal.ui.text.hyperlink.RubyRequireHyperlinkDetector;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class RubyRequireHyperlinkDetectorTest
extends SuiteOfTestCases {
    private final TestDetector detector = new TestDetector();

    public RubyRequireHyperlinkDetectorTest(String name) {
        super(name);
    }

    private void detect(String line, int offset, int length) {
        IHyperlink hyperlink = this.detector.checkLine(line);
        RubyRequireHyperlinkDetectorTest.assertNotNull((Object)hyperlink);
        RubyRequireHyperlinkDetectorTest.assertEquals((int)offset, (int)hyperlink.getHyperlinkRegion().getOffset());
        RubyRequireHyperlinkDetectorTest.assertEquals((int)length, (int)hyperlink.getHyperlinkRegion().getLength());
        RubyRequireHyperlinkDetectorTest.assertEquals((String)line.substring(offset, offset + length), (String)hyperlink.getHyperlinkText());
    }

    public void testSingleQuotes() {
        this.detect("require 'abc'", 9, 3);
    }

    public void testDoubleQuotes() {
        this.detect("require \"abc\"", 9, 3);
    }

    public void testManySpaces() {
        this.detect(" require  \"abc\"", 11, 3);
    }

    public void testBracketsSingleQuotes() {
        this.detect("require('abc')", 9, 3);
    }

    public void testBracketsDoubleQuotes() {
        this.detect("require(\"abc\")", 9, 3);
    }

    public void testBracketsAndSpaces() {
        this.detect("require( 'abc' )", 10, 3);
    }

    public void testNoHyperlink() {
        RubyRequireHyperlinkDetectorTest.assertNull((Object)this.detector.checkLine("require abc"));
        RubyRequireHyperlinkDetectorTest.assertNull((Object)this.detector.checkLine("require 'abc\""));
        RubyRequireHyperlinkDetectorTest.assertNull((Object)this.detector.checkLine("require \"abc'"));
        RubyRequireHyperlinkDetectorTest.assertNull((Object)this.detector.checkLine("require(abc)"));
        RubyRequireHyperlinkDetectorTest.assertNull((Object)this.detector.checkLine("require('abc\")"));
    }

    private final class TestDetector
    extends RubyRequireHyperlinkDetector {
        private TestDetector() {
        }

        public IHyperlink checkLine(String line) {
            return this.checkLine(0, line);
        }

        protected IHyperlink createLink(int offset, String line, int begin, int end) {
            String requiredFile = line.substring(begin, end);
            Region region = new Region(offset + begin, end - begin);
            return new TestHyperlink(requiredFile, (IRegion)region);
        }
    }

    private static class TestHyperlink
    implements IHyperlink {
        private final String path;
        private final IRegion region;

        public TestHyperlink(String path, IRegion region) {
            this.path = path;
            this.region = region;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return this.path;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
        }
    }
}

