/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug.tests.launching;

import java.util.ArrayList;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.tests.launching.ScriptLaunchingTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ruby.debug.RubyDebugPlugin;
import org.eclipse.dltk.ruby.launching.RubyLaunchConfigurationDelegate;

public class RubyLaunchingTests
extends ScriptLaunchingTests {
    static /* synthetic */ Class class$0;

    public RubyLaunchingTests(String name) {
        super("org.eclipse.dltk.ruby.debug.tests", name);
    }

    public RubyLaunchingTests(String testProjectName, String name) {
        super(testProjectName, name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.debug.tests.launching.RubyLaunchingTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    protected String getProjectName() {
        return "launching";
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    protected String getDebugModelId() {
        return "org.eclipse.dltk.debug.rubyModel";
    }

    protected ILaunchConfiguration createLaunchConfiguration(String arguments) {
        return this.createTestLaunchConfiguration(this.getNatureId(), this.getProjectName(), "src/test.rb", arguments);
    }

    protected void startLaunch(ILaunch launch, final IInterpreterInstall install) throws CoreException {
        RubyLaunchConfigurationDelegate delegate = new RubyLaunchConfigurationDelegate(){

            public IInterpreterInstall getInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
                return install;
            }
        };
        delegate.launch(launch.getLaunchConfiguration(), launch.getLaunchMode(), launch, null);
    }

    public void testDebugRuby() throws Exception {
        RubyDebugPlugin.getDefault().getPluginPreferences().setValue("debugging_engine_id", "org.eclipse.dltk.ruby.basicdebugger");
        ScriptLaunchingTests.DebugEventStats stats = this.internalTestDebug("ruby");
        int suspendCount = stats.getSuspendCount();
        RubyLaunchingTests.assertEquals((int)1, (int)suspendCount);
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeVmStarted());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeCodeLoaded());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeSuspendCount());
    }

    public void testFastDebugRuby() throws Exception {
        RubyDebugPlugin.getDefault().getPluginPreferences().setValue("debugging_engine_id", "org.eclipse.dltk.ruby.fastdebugger");
        ScriptLaunchingTests.DebugEventStats stats = this.internalTestDebug("ruby");
        int suspendCount = stats.getSuspendCount();
        RubyLaunchingTests.assertEquals((int)1, (int)suspendCount);
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeVmStarted());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeCodeLoaded());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeSuspendCount());
    }

    public void testDebugJRuby() throws Exception {
        RubyDebugPlugin.getDefault().getPluginPreferences().setValue("debugging_engine_id", "org.eclipse.dltk.ruby.basicdebugger");
        ScriptLaunchingTests.DebugEventStats stats = this.internalTestDebug("jruby");
        int suspendCount = stats.getSuspendCount();
        RubyLaunchingTests.assertEquals((int)1, (int)suspendCount);
        RubyLaunchingTests.assertEquals((int)2, (int)stats.getResumeCount());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeVmStarted());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeCodeLoaded());
        RubyLaunchingTests.assertEquals((int)2, (int)stats.getBeforeResumeCount());
        RubyLaunchingTests.assertEquals((int)1, (int)stats.getBeforeSuspendCount());
    }

    public void testRuby() throws Exception {
        String NAME = "ruby";
        this.internalTestRequiredInterpreterAvailable(NAME);
        this.internalTestRun(NAME);
    }

    public void testJRuby() throws Exception {
        String NAME = "jruby";
        this.internalTestRequiredInterpreterAvailable(NAME);
        this.internalTestRun(NAME);
    }

    protected IInterpreterInstall[] getPredefinedInterpreterInstalls() {
        IInterpreterInstallType[] installTypes = ScriptRuntime.getInterpreterInstallTypes((String)"org.eclipse.dltk.ruby.core.nature");
        int id = 0;
        ArrayList installs = new ArrayList();
        int i = 0;
        while (i < installTypes.length) {
            String installId = String.valueOf(this.getNatureId()) + "_";
            this.createAddInstall(installs, "/usr/bin/ruby", String.valueOf(installId) + Integer.toString(++id), installTypes[i]);
            this.createAddInstall(installs, "/home/dltk/apps/jruby/bin/jruby", String.valueOf(installId) + Integer.toString(++id), installTypes[i]);
            ++i;
        }
        if (installs.size() > 0) {
            return installs.toArray(new IInterpreterInstall[installs.size()]);
        }
        return this.searchInstalls("org.eclipse.dltk.ruby.core.nature");
    }

    protected boolean hasPredefinedInterpreters() {
        return true;
    }
}

