/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug.tests.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.debug.RubyFilenameLinenumberResolver;

public class RubyFilenameLinenumberTests
extends SuiteOfTestCases {
    private final Pattern pattern;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.debug.tests.console.RubyFilenameLinenumberTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public RubyFilenameLinenumberTests(String name) {
        super(name);
        RubyFilenameLinenumberResolver resolver = new RubyFilenameLinenumberResolver();
        this.pattern = Pattern.compile(resolver.resolveValue(null, null));
    }

    public void testSimple() throws Exception {
        RubyFilenameLinenumberTests.assertTrue((boolean)this.pattern.matcher("script.rb:2").matches());
    }

    public void testRoot() throws Exception {
        RubyFilenameLinenumberTests.assertTrue((boolean)this.pattern.matcher("/script.rb:2").matches());
    }

    public void testFullWindows() throws Exception {
        RubyFilenameLinenumberTests.assertTrue((boolean)this.pattern.matcher("C:/runtime/A/script.rb:2").matches());
    }

    public void testFullUnix() throws Exception {
        RubyFilenameLinenumberTests.assertTrue((boolean)this.pattern.matcher("/home/user/runtime/A/script.rb:2").matches());
    }

    public void testFrom() throws Exception {
        Matcher m = this.pattern.matcher("from c:/ruby/lib/ruby/site_ruby/1.8/rubygems.rb:61:in `require_gem'");
        RubyFilenameLinenumberTests.assertTrue((boolean)m.find());
        RubyFilenameLinenumberTests.assertEquals((int)2, (int)m.groupCount());
        RubyFilenameLinenumberTests.assertEquals((String)"61", (String)m.group(2));
        String filename = m.group(1);
        RubyFilenameLinenumberTests.assertTrue((boolean)filename.startsWith("c:/"));
        RubyFilenameLinenumberTests.assertTrue((boolean)filename.endsWith("rubygems.rb"));
    }

    public void testNegativeMatch() {
    }
}

