/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;
import org.eclipse.dltk.internal.debug.core.model.operations.IDbgpDebuggerFeedback;

public class ScriptThreadStateManager
implements IDbgpDebuggerFeedback {
    private IStateChangeHandler handler;
    private final DbgpDebugger engine;
    private boolean canSuspend;
    private int modificationsCount;
    private boolean stepping;
    private boolean suspended;
    private boolean terminated;
    private boolean stepIntoState;

    protected void handleStatus(DbgpException exception, IDbgpStatus status, int suspendDetail) {
        if (exception != null) {
            this.setTerminated(exception);
        }
        if (status == null) {
            this.setTerminated(null);
            return;
        }
        if (status.isBreak()) {
            this.setSuspended(true, suspendDetail);
        } else if (status.isStopping()) {
            try {
                this.terminate();
            }
            catch (DebugException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
        } else if (status.isStopped()) {
            this.setTerminated(null);
        }
    }

    protected void setSuspended(boolean value, int detail) {
        this.suspended = value;
        if (value) {
            ++this.modificationsCount;
        }
        if (value) {
            this.handler.handleSuspend(detail);
        } else {
            this.handler.handleResume(detail);
        }
    }

    private void setTerminated(DbgpException e) {
        this.terminated = true;
        this.handler.handleTermination(e);
    }

    private boolean canStep() {
        return !this.terminated && this.suspended;
    }

    private void beginStep(int detail) {
        this.stepping = true;
        this.setSuspended(false, detail);
    }

    private void endStep(DbgpException execption, IDbgpStatus status) {
        this.stepping = false;
        this.handleStatus(execption, status, 8);
    }

    public ScriptThreadStateManager(ScriptThread thread) {
        this.handler = thread;
        this.engine = new DbgpDebugger(thread, this);
        this.canSuspend = true;
        this.modificationsCount = 0;
        this.suspended = true;
        this.terminated = false;
        this.stepping = this.suspended;
    }

    public DbgpDebugger getEngine() {
        return this.engine;
    }

    public boolean isStepping() {
        return !this.terminated && this.stepping;
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public void endStepInto(DbgpException e, IDbgpStatus status) {
        this.endStep(e, status);
    }

    public void stepInto() throws DebugException {
        this.beginStep(1);
        this.stepIntoState = true;
        this.engine.stepInto();
    }

    public boolean isStepInto() {
        return this.stepIntoState;
    }

    public void setStepInto(boolean state) {
        this.stepIntoState = state;
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public void endStepOver(DbgpException e, IDbgpStatus status) {
        this.endStep(e, status);
    }

    public void stepOver() throws DebugException {
        this.beginStep(2);
        this.engine.stepOver();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    public void endStepReturn(DbgpException e, IDbgpStatus status) {
        this.endStep(e, status);
    }

    public void stepReturn() throws DebugException {
        this.beginStep(4);
        this.engine.stepReturn();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean canSuspend() {
        return this.canSuspend && !this.terminated && !this.suspended;
    }

    public void endSuspend(DbgpException e, IDbgpStatus status) {
        this.handleStatus(e, status, 32);
    }

    public void suspend() throws DebugException {
        this.engine.suspend();
        this.setSuspended(true, 32);
    }

    public int getModificationsCount() {
        return this.modificationsCount;
    }

    public boolean canResume() {
        return !this.terminated && this.suspended;
    }

    public void endResume(DbgpException e, IDbgpStatus status) {
        this.handleStatus(e, status, 16);
    }

    public void resume() throws DebugException {
        this.setSuspended(false, 32);
        this.engine.resume();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public void endTerminate(DbgpException e, IDbgpStatus status) {
        this.handleStatus(e, status, 32);
    }

    public void terminate() throws DebugException {
        this.engine.terminate();
    }

    public void notifyModified() {
        ++this.modificationsCount;
    }

    public static interface IStateChangeHandler {
        public void handleSuspend(int var1);

        public void handleResume(int var1);

        public void handleTermination(DbgpException var1);
    }
}

