/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests.service;

import java.io.IOException;
import org.eclipse.dltk.dbgp.DbgpServer;
import org.eclipse.dltk.debug.dbgp.tests.service.AbstractDbgpServiceTests;
import org.eclipse.dltk.internal.debug.core.model.DbgpService;

public class DbgpServiceTests
extends AbstractDbgpServiceTests {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testConnect() throws IOException {
        DbgpService service = this.createService(-1);
        try {
            this.connect(service.getPort());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            service.shutdown();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        service.shutdown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testConnectDelayed() throws IOException {
        DbgpService service = new DbgpService(-1){

            protected DbgpServer createServer(int port) {
                return new DbgpServer(this, port, 10000000){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected void workingCycle() throws Exception, IOException {
                        Thread.sleep(1000L);
                        super.workingCycle();
                    }
                };
            }
        };
        DbgpServiceTests.assertTrue((boolean)service.waitStarted());
        try {
            this.connect(service.getPort());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            service.shutdown();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        service.shutdown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testShutdown() throws IOException {
        int port = DbgpServiceTests.findAvailablePort(32768, 65535);
        int i = 0;
        while (i < 4) {
            Object var4_4;
            DbgpService service = this.createService(port);
            try {
                this.connect(port);
            }
            catch (Throwable throwable) {
                var4_4 = null;
                service.shutdown();
                throw throwable;
            }
            {
                var4_4 = null;
            }
            service.shutdown();
            {
                this.connect(port);
                DbgpServiceTests.fail((String)"Should fail - the service is shutted down");
            }
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _testRestart() throws IOException {
        int port1 = DbgpServiceTests.findAvailablePort(32768, 65535);
        int port2 = DbgpServiceTests.findAvailablePort(port1 + 1, 65535);
        int i = 0;
        while (i < 4) {
            Object var5_5;
            DbgpService service = this.createService(port1);
            try {
                DbgpServiceTests.assertEquals((int)port1, (int)service.getPort());
                this.connect(port1);
                try {
                    this.connect(port2);
                    DbgpServiceTests.fail((String)"Should fail - the service is listen on port1 now");
                }
                catch (IOException iOException) {}
                service.restart(port2);
                try {
                    this.connect(port1);
                    DbgpServiceTests.fail((String)"Should fail - the service is listen on port2 now");
                }
                catch (IOException iOException) {}
                this.connect(port2);
            }
            catch (Throwable throwable) {
                var5_5 = null;
                service.shutdown();
                throw throwable;
            }
            {
                var5_5 = null;
            }
            service.shutdown();
            ++i;
        }
        return;
    }
}

