/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.basicdebugger;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.launching.DebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpInterpreterConfig;
import org.eclipse.dltk.ruby.basicdebugger.Messages;
import org.eclipse.dltk.ruby.basicdebugger.RubyBasicDebuggerPlugin;
import org.eclipse.dltk.ruby.internal.launching.JRubyInstallType;

public class RubyBasicDebuggerRunner
extends DebuggingEngineRunner {
    public static final String ENGINE_ID = "org.eclipse.dltk.ruby.basicdebugger";
    private static final String RUBY_HOST_VAR = "DBGP_RUBY_HOST";
    private static final String RUBY_PORT_VAR = "DBGP_RUBY_PORT";
    private static final String RUBY_KEY_VAR = "DBGP_RUBY_KEY";
    private static final String RUBY_LOG_VAR = "DBGP_RUBY_LOG";
    private static final String DEBUGGER_SCRIPT = "BasicRunner.rb";
    static /* synthetic */ Class class$0;

    protected IPath deploy(IDeployment deployment) throws CoreException {
        try {
            IPath deploymentPath = RubyBasicDebuggerPlugin.getDefault().deployDebuggerSource(deployment);
            return deployment.getFile(deploymentPath).getPath();
        }
        catch (IOException e) {
            this.abort(Messages.RubyBasicDebuggerRunner_unableToDeployDebuggerSource, e);
            return null;
        }
    }

    public RubyBasicDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig addEngineConfig(InterpreterConfig config, PreferencesLookupDelegate delegate, ILaunch launch) throws CoreException {
        IEnvironment env = this.getInstall().getEnvironment();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IExecutionEnvironment exeEnv = (IExecutionEnvironment)env.getAdapter((Class)clazz);
        IDeployment deployment = exeEnv.createDeployment();
        DeploymentManager.getInstance().addDeployment(launch, deployment);
        IPath sourceLocation = this.deploy(deployment);
        IPath scriptFile = sourceLocation.append(DEBUGGER_SCRIPT);
        InterpreterConfig newConfig = (InterpreterConfig)config.clone();
        if (this.getInstall().getInterpreterInstallType() instanceof JRubyInstallType) {
            newConfig.addEnvVar("JAVA_OPTS", "-Djruby.jit.enabled=false");
        }
        newConfig.addInterpreterArg("-r");
        newConfig.addInterpreterArg(env.convertPathToString(scriptFile));
        newConfig.addInterpreterArg("-I");
        newConfig.addInterpreterArg(env.convertPathToString(sourceLocation));
        DbgpInterpreterConfig dbgpConfig = new DbgpInterpreterConfig(config);
        String sessionId = dbgpConfig.getSessionId();
        newConfig.addEnvVar(RUBY_HOST_VAR, dbgpConfig.getHost());
        newConfig.addEnvVar(RUBY_PORT_VAR, Integer.toString(dbgpConfig.getPort()));
        newConfig.addEnvVar(RUBY_KEY_VAR, sessionId);
        String logFileName = this.getLogFileName(delegate, sessionId);
        if (logFileName != null) {
            newConfig.addEnvVar(RUBY_LOG_VAR, logFileName);
        }
        return newConfig;
    }

    protected String getDebuggingEngineId() {
        return ENGINE_ID;
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.dltk.ruby.debug";
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return ENGINE_ID;
    }

    protected String getLoggingEnabledPreferenceKey() {
        return "enable_logging";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected String getLogFilePathPreferenceKey() {
        return "log_file_path";
    }
}

