/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.AbstractAutoFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.dltk.ui.DLTKDeclarationsFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;

public class FocusScriptExplorerAction
extends AbstractAutoFocusViewAction {
    public FocusScriptExplorerAction() {
        super(new InterestFilter(), true, true, true);
    }

    protected ISelection resolveSelection(IEditorPart part, ITextSelection changedSelection, StructuredViewer viewer) throws CoreException {
        StructuredSelection currentSelection;
        TextSelection textSelection;
        IModelElement modelElement;
        IModelElement elementToSelect = null;
        if (changedSelection instanceof TextSelection && part instanceof ScriptEditor && (modelElement = SelectionConverter.resolveEnclosingElement((IEditorPart)((ScriptEditor)part), (ITextSelection)(textSelection = (TextSelection)changedSelection))) != null) {
            elementToSelect = modelElement;
        }
        if (elementToSelect != null && (currentSelection = (StructuredSelection)viewer.getSelection()).size() <= 1) {
            ListIterator<ViewerFilter> it = Arrays.asList(viewer.getFilters()).listIterator();
            while (it.hasNext()) {
                ViewerFilter filter = it.next();
                if (!(filter instanceof DLTKDeclarationsFilter) || !(elementToSelect instanceof IMember)) continue;
                elementToSelect = ((IMember)elementToSelect).getSourceModule();
            }
        }
        return new StructuredSelection(elementToSelect);
    }

    protected void setDefaultLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            ((ScriptExplorerPart)part).setLinkingEnabled(on);
        }
    }

    protected boolean isDefaultLinkingEnabled() {
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            return ((ScriptExplorerPart)part).isLinkingEnabled();
        }
        return false;
    }

    public List getViewers() {
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        IViewPart part = super.getPartForAction();
        if (part instanceof ScriptExplorerPart) {
            viewers.add(((ScriptExplorerPart)part).getTreeViewer());
        }
        return viewers;
    }
}

