/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.dltk.MylynDLTKPlugin;
import org.eclipse.swt.graphics.Image;

public class DLTKContextLabelProvider
extends AppearanceAwareLabelProvider {
    private static final String LABEL_ELEMENT_MISSING = "<missing element>";
    private static final ImageDescriptor EDGE_REF_JUNIT = MylynDLTKPlugin.getImageDescriptor("icons/elcl16/edge-ref-junit.gif");

    public DLTKContextLabelProvider() {
        super(564186904002603L, 1, MylynDLTKPlugin.getDefault().getPreferenceStore());
    }

    public String getText(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            IModelElement element = DLTKCore.create((String)node.getHandleIdentifier());
            if (element == null) {
                return LABEL_ELEMENT_MISSING;
            }
            return this.getTextForElement(element);
        }
        if (object instanceof IInteractionRelation) {
            return this.getNameForRelationship(((IInteractionRelation)object).getRelationshipHandle());
        }
        if (object instanceof IModelElement) {
            return this.getTextForElement((IModelElement)object);
        }
        return super.getText(object);
    }

    private String getTextForElement(IModelElement element) {
        String parentName;
        if (element instanceof IMember && !(element instanceof IType) && (parentName = ((IMember)element).getParent().getElementName()) != null && parentName != "") {
            return String.valueOf(parentName) + '.' + super.getText((Object)element);
        }
        if (element.exists()) {
            return super.getText((Object)element);
        }
        return LABEL_ELEMENT_MISSING;
    }

    public Image getImage(Object object) {
        if (object instanceof IInteractionElement) {
            IInteractionElement node = (IInteractionElement)object;
            return super.getImage((Object)DLTKCore.create((String)node.getHandleIdentifier()));
        }
        if (object instanceof IInteractionRelation) {
            ImageDescriptor descriptor = this.getIconForRelationship(((IInteractionRelation)object).getRelationshipHandle());
            if (descriptor != null) {
                return ContextUiImages.getImage((ImageDescriptor)descriptor);
            }
            return null;
        }
        return super.getImage(object);
    }

    private ImageDescriptor getIconForRelationship(String relationshipHandle) {
        return null;
    }

    private String getNameForRelationship(String relationshipHandle) {
        return null;
    }

    public static AppearanceAwareLabelProvider createJavaUiLabelProvider() {
        AppearanceAwareLabelProvider scriptUiLabelProvider = new AppearanceAwareLabelProvider(564186904002603L, 1, MylynDLTKPlugin.getDefault().getPreferenceStore());
        return scriptUiLabelProvider;
    }
}

