/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IScriptBuilder;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.mixin.Messages;
import org.eclipse.dltk.internal.core.mixin.MixinIndexer;
import org.eclipse.dltk.internal.core.mixin.MixinManager;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;

public class MixinBuilder
implements IScriptBuilder {
    private static MixinBuilder builder = new MixinBuilder();

    public IStatus buildResources(IScriptProject project, List resources, IProgressMonitor monitor, int status) {
        return null;
    }

    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, int status) {
        return this.buildModelElements(project, elements, monitor, true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, boolean saveIndex) {
        block58: {
            block53: {
                block57: {
                    block52: {
                        block55: {
                            block49: {
                                block50: {
                                    block48: {
                                        if (elements.size() == 0) {
                                            return null;
                                        }
                                        manager = ModelManager.getModelManager().getIndexManager();
                                        elementsSize = elements.size();
                                        toolkit = null;
                                        parser = null;
                                        try {
                                            toolkit = DLTKLanguageManager.getLanguageToolkit(project);
                                            if (toolkit != null) {
                                                parser = MixinManager.getMixinParser(toolkit.getNatureId());
                                            }
                                        }
                                        catch (CoreException e1) {
                                            if (!DLTKCore.DEBUG) break block48;
                                            e1.printStackTrace();
                                        }
                                    }
                                    if (parser == null) return null;
                                    if (toolkit == null) {
                                        return null;
                                    }
                                    indexes = new HashMap<IPath, Index>();
                                    mixinIndex = null;
                                    imon = null;
                                    try {
                                        fullPath = project.getProject().getFullPath();
                                        fullContainerPath = fullPath.getDevice() == null ? fullPath.toString() : fullPath.toOSString();
                                        mixinIndex = manager.getSpecialIndex("mixin", fullPath.toString(), fullContainerPath);
                                        imon = mixinIndex.monitor;
                                        imon.enterWrite();
                                        name = MessageFormat.format(Messages.MixinBuilder_buildingRuntimeModelFor, new Object[]{project.getElementName()});
                                        if (monitor != null) {
                                            monitor.beginTask(name, elementsSize);
                                        }
                                        fileIndex = 0;
                                        iterator = elements.iterator();
                                        while (iterator.hasNext()) {
                                            block54: {
                                                element = (ISourceModule)iterator.next();
                                                currentIndex = mixinIndex;
                                                if (monitor == null || !monitor.isCanceled()) break block54;
                                                var25_26 = null;
                                                saveIndexesSet = new HashSet<Index>();
                                                if (mixinIndex != null) {
                                                    if (saveIndex) {
                                                        saveIndexesSet.add(mixinIndex);
                                                    } else {
                                                        imon.exitWrite();
                                                    }
                                                }
                                                iterator = indexes.values().iterator();
                                                if (true) ** GOTO lbl119
                                            }
                                            taskTitle = MessageFormat.format(Messages.MixinBuilder_buildingRuntimeModelFor2, new Object[]{project.getElementName(), new Integer(elements.size() - fileIndex), element.getElementName()});
                                            ++fileIndex;
                                            if (monitor != null) {
                                                monitor.subTask(taskTitle);
                                            }
                                            projectFragment = (IProjectFragment)element.getAncestor(3);
                                            containerPath = project.getPath();
                                            if (projectFragment instanceof ExternalProjectFragment || projectFragment instanceof BuiltinProjectFragment) {
                                                path = projectFragment.getPath();
                                                if (indexes.containsKey(path)) {
                                                    currentIndex = (Index)indexes.get(path);
                                                    containerPath = path;
                                                } else {
                                                    contPath = path.toString();
                                                    index = manager.getSpecialIndex("mixin", path.toString(), contPath);
                                                    if (index != null) {
                                                        currentIndex = index;
                                                        if (!indexes.values().contains(index)) {
                                                            index.monitor.enterWrite();
                                                            indexes.put(path, index);
                                                        }
                                                        containerPath = path;
                                                    }
                                                }
                                            }
                                            participant = SearchEngine.getDefaultSearchParticipant();
                                            document = new DLTKSearchDocument(element.getPath().toString(), containerPath, null, participant, element instanceof ExternalSourceModule, element.getScriptProject().getProject());
                                            document.toolkit = toolkit;
                                            containerRelativePath = null;
                                            if (element instanceof ExternalSourceModule) {
                                                containerRelativePath = element.getPath().removeFirstSegments(containerPath.segmentCount()).setDevice(null).toString();
                                            } else if (element instanceof SourceModule) {
                                                containerRelativePath = element.getPath().removeFirstSegments(1).toPortableString();
                                            } else if (element instanceof BuiltinSourceModule) {
                                                containerRelativePath = document.getPath();
                                            }
                                            document.setContainerRelativePath(containerRelativePath);
                                            currentIndex.remove(containerRelativePath);
                                            document.setIndex(currentIndex);
                                            new MixinIndexer(document, element, currentIndex).indexDocument();
                                            if (monitor == null) continue;
                                            monitor.worked(1);
                                        }
                                        var25_28 = null;
                                        saveIndexesSet = new HashSet<Index>();
                                        if (mixinIndex == null) break block49;
                                        if (!saveIndex) break block50;
                                        saveIndexesSet.add(mixinIndex);
                                        break block49;
                                    }
                                    catch (Throwable var26_50) {
                                        var25_27 = null;
                                        saveIndexesSet = new HashSet<Index>();
                                        if (mixinIndex != null) {
                                            if (saveIndex) {
                                                saveIndexesSet.add(mixinIndex);
                                            } else {
                                                imon.exitWrite();
                                            }
                                        }
                                        iterator = indexes.values().iterator();
                                        if (true) ** GOTO lbl154
                                    }
                                }
                                imon.exitWrite();
                            }
                            iterator = indexes.values().iterator();
                            if (true) ** GOTO lbl188
                            do {
                                index = (Index)iterator.next();
                                if (saveIndex) {
                                    saveIndexesSet.add(index);
                                    continue;
                                }
                                index.monitor.exitWrite();
lbl119:
                                // 3 sources

                            } while (iterator.hasNext());
                            if (!saveIndex || !(ind = saveIndexesSet.iterator()).hasNext()) break block55;
                            index = (Index)ind.next();
                            if (monitor != null) {
                                containerPath = Path.fromPortableString((String)index.containerPath).setDevice(null).toString();
                                if (containerPath.startsWith("#special#")) {
                                    containerPath = containerPath.substring(containerPath.lastIndexOf("#"), containerPath.length());
                                }
                                monitor.subTask(MessageFormat.format(Messages.MixinBuilder_savingIndexFor, new Object[]{containerPath}));
                            }
                            try {
                                block51: {
                                    try {
                                        index.save();
                                    }
                                    catch (IOException e) {
                                        if (!DLTKCore.DEBUG) break block51;
                                        e.printStackTrace();
                                    }
                                }
                                v0 = null;
                            }
                            catch (Throwable var33_44) {
                                v0 = null;
                            }
                            var32_47 = v0;
                            index.monitor.exitWrite();
                            return null;
                        }
                        if (monitor == null) return null;
                        monitor.done();
                        return null;
                        do {
                            index = (Index)iterator.next();
                            if (saveIndex) {
                                saveIndexesSet.add(index);
                                continue;
                            }
                            index.monitor.exitWrite();
lbl154:
                            // 3 sources

                        } while (iterator.hasNext());
                        if (!saveIndex || !(ind = saveIndexesSet.iterator()).hasNext()) break block57;
                        index = (Index)ind.next();
                        if (monitor != null) {
                            containerPath = Path.fromPortableString((String)index.containerPath).setDevice(null).toString();
                            if (containerPath.startsWith("#special#")) {
                                containerPath = containerPath.substring(containerPath.lastIndexOf("#"), containerPath.length());
                            }
                            monitor.subTask(MessageFormat.format(Messages.MixinBuilder_savingIndexFor, new Object[]{containerPath}));
                        }
                        try {}
                        catch (Throwable var33_45) {
                            v1 = null;
lbl165:
                            // 2 sources

                            var32_48 = v1;
                            index.monitor.exitWrite();
                            throw var26_50;
                        }
                        ** try [egrp 3[TRYBLOCK] [4 : 901->909)] { 
lbl169:
                        // 1 sources

                        index.save();
lbl171:
                        // 1 sources

                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block52;
                            e.printStackTrace();
                        }
                    }
                    v1 = null;
                    ** GOTO lbl165
                }
                if (monitor == null) throw var26_50;
                monitor.done();
                throw var26_50;
                do {
                    index = (Index)iterator.next();
                    if (saveIndex) {
                        saveIndexesSet.add(index);
                        continue;
                    }
                    index.monitor.exitWrite();
lbl188:
                    // 3 sources

                } while (iterator.hasNext());
                if (!saveIndex || !(ind = saveIndexesSet.iterator()).hasNext()) break block58;
                index = (Index)ind.next();
                if (monitor != null) {
                    containerPath = Path.fromPortableString((String)index.containerPath).setDevice(null).toString();
                    if (containerPath.startsWith("#special#")) {
                        containerPath = containerPath.substring(containerPath.lastIndexOf("#"), containerPath.length());
                    }
                    monitor.subTask(MessageFormat.format(Messages.MixinBuilder_savingIndexFor, new Object[]{containerPath}));
                }
                try {}
                catch (Throwable var33_46) {
                    v2 = null;
lbl199:
                    // 2 sources

                    var32_49 = v2;
                    index.monitor.exitWrite();
                    return null;
                }
                ** try [egrp 3[TRYBLOCK] [4 : 901->909)] { 
lbl203:
                // 1 sources

                index.save();
lbl205:
                // 1 sources

                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block53;
                    e.printStackTrace();
                }
            }
            v2 = null;
            ** GOTO lbl199
        }
        if (monitor == null) return null;
        monitor.done();
        return null;
    }

    public static MixinBuilder getDefault() {
        return builder;
    }

    public int estimateElementsToBuild(List elements) {
        return elements.size();
    }

    public Set getDependencies(IScriptProject project, Set resources, Set allResources, Set oldExternalFolders, Set externalFolders) {
        return null;
    }
}

