/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.task.ITaskReporter;

public class DLTKTaskReporter
implements ITaskReporter {
    private final IResource resource;
    private boolean tasksCleared;

    public DLTKTaskReporter(IResource resource) {
        this.resource = resource;
        this.tasksCleared = false;
    }

    public void clearTasks() {
        if (!this.tasksCleared) {
            try {
                this.resource.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
            }
            catch (CoreException e) {
                System.err.println((Object)e);
            }
            this.tasksCleared = true;
        }
    }

    public void reportTask(String message, int lineNumber, int priority, int charStart, int charEnd) throws CoreException {
        IMarker m = this.resource.createMarker("org.eclipse.core.resources.taskmarker");
        m.setAttribute("lineNumber", lineNumber + 1);
        m.setAttribute("message", (Object)message);
        m.setAttribute("priority", priority);
        m.setAttribute("charStart", charStart);
        m.setAttribute("charEnd", charEnd);
        m.setAttribute("userEditable", (Object)Boolean.FALSE);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

