/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ArchiveEntryFile;
import org.eclipse.dltk.internal.core.ArchiveFolderInfo;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.util.Util;

public class ArchiveFolder
extends ScriptFolder {
    public ArchiveFolder(ProjectFragment parent, IPath path) {
        super(parent, path);
    }

    void computeForeignResources(String[] resNames, ArchiveFolderInfo info, String zipName) {
        if (resNames == null) {
            info.setForeignResources(null);
            return;
        }
        int max = resNames.length;
        if (max == 0) {
            info.setForeignResources(ModelElementInfo.NO_NON_SCRIPT_RESOURCES);
        } else {
            Object[] res = new Object[max];
            int index = 0;
            int i = 0;
            while (i < max) {
                String resName = resNames[i];
                if (!Util.isValidSourceModuleName(this.getScriptProject(), resName)) {
                    IPath parentRelativePath = new Path(resName).removeFirstSegments(this.path.segmentCount());
                    res[index++] = new ArchiveEntryFile(resName, zipName, parentRelativePath, this.getProjectFragment().getResource());
                }
                ++i;
            }
            if (index != max) {
                Object[] objectArray = res;
                res = new Object[index];
                System.arraycopy(objectArray, 0, res, 0, index);
            }
            info.setForeignResources(res);
        }
    }

    public ISourceModule getSourceModule(String name) {
        ArchiveProjectFragment fragment = (ArchiveProjectFragment)this.getProjectFragment();
        return new ExternalSourceModule(this, name, DefaultWorkingCopyOwner.PRIMARY, true, new ArchiveEntryFile(name, fragment.getZipName(), this.path, fragment.getResource()));
    }

    protected boolean computeChildren(OpenableElementInfo info, ArrayList entryNames) {
        if (entryNames != null && entryNames.size() > 0) {
            ArrayList<ISourceModule> vChildren = new ArrayList<ISourceModule>();
            Iterator iter = entryNames.iterator();
            while (iter.hasNext()) {
                String child = (String)iter.next();
                ISourceModule classFile = this.getSourceModule(child);
                vChildren.add(classFile);
            }
            IModelElement[] children = new IModelElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(NO_ELEMENTS);
        }
        return true;
    }

    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected Object createElementInfo() {
        return null;
    }

    public Object[] getForeignResources() throws ModelException {
        return ((ArchiveFolderInfo)this.getElementInfo()).getForeignResources();
    }
}

