/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.validators.core.IValidator;
import org.eclipse.dltk.validators.internal.core.Messages;
import org.eclipse.dltk.validators.internal.core.ValidatorDefinitionsContainer;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

public class ValidatorsCore
extends Plugin
implements Preferences.IPropertyChangeListener {
    public static final String PLUGIN_ID = "org.eclipse.dltk.validators.core";
    private static ValidatorsCore plugin;
    private boolean fIgnoreValidatorDefPropertyChangeEvents = false;
    private static final String EMPTY_STRING = "";
    private String fOldInterpreterPrefString = "";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ValidatorsCore getDefault() {
        return plugin;
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static String serializeDocument(Document doc) throws IOException, TransformerException {
        StringWriter s = new StringWriter();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString();
    }

    public void setIgnoreValidatorDefPropertyChangeEvents(boolean ignore) {
        this.fIgnoreValidatorDefPropertyChangeEvents = ignore;
    }

    public boolean isIgnoreValidatorDefPropertyChangeEvents() {
        return this.fIgnoreValidatorDefPropertyChangeEvents;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("org.eclipse.dltk.validators.core.PREF_VALIDATOR_XML") && !this.isIgnoreValidatorDefPropertyChangeEvents()) {
            this.processValidatorPrefsChanged((String)event.getOldValue(), (String)event.getNewValue());
        }
    }

    private ValidatorDefinitionsContainer getValidatorDefinitions(String xml) {
        if (xml.length() > 0) {
            try {
                return ValidatorDefinitionsContainer.parseXMLIntoContainer(new StringReader(xml));
            }
            catch (IOException e) {
                ValidatorsCore.getDefault().getLog().log((IStatus)new Status(0, PLUGIN_ID, 0, Messages.ValidatorsCore_exception, (Throwable)e));
            }
        }
        return new ValidatorDefinitionsContainer();
    }

    protected void processValidatorPrefsChanged(String oldValue, String newValue) {
        String newPrefString;
        String oldPrefString;
        if (newValue == null || newValue.equals(EMPTY_STRING)) {
            this.fOldInterpreterPrefString = oldValue;
            return;
        }
        if (oldValue == null || oldValue.equals(EMPTY_STRING)) {
            oldPrefString = this.fOldInterpreterPrefString;
            newPrefString = newValue;
        } else {
            oldPrefString = oldValue;
            newPrefString = newValue;
        }
        ValidatorDefinitionsContainer oldResults = this.getValidatorDefinitions(oldPrefString);
        ValidatorDefinitionsContainer newResults = this.getValidatorDefinitions(newPrefString);
        List deleted = oldResults.getValidatorList();
        List current = newResults.getValidatorList();
        deleted.removeAll(current);
        Iterator deletedIterator = deleted.iterator();
        while (deletedIterator.hasNext()) {
            IValidator deletedValidatorStandin = (IValidator)deletedIterator.next();
            deletedValidatorStandin.getValidatorType().disposeValidator(deletedValidatorStandin.getID());
        }
    }
}

