/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.testing.MemberResolverManager;
import org.eclipse.dltk.internal.testing.ui.OpenEditorAction;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.ITestingElementResolver;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private ISourceRange fRange;

    public OpenTestAction(TestRunnerViewPart testRunner, String className, String method) {
        this(testRunner, className, method, true);
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className) {
        this(testRunner, className, null);
    }

    public OpenTestAction(TestRunnerViewPart testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.dltk.testing.open_test_action_context");
        this.fMethodName = method;
    }

    protected void reveal(ITextEditor textEditor) {
        if (this.fRange != null) {
            textEditor.selectAndReveal(this.fRange.getOffset(), this.fRange.getLength());
        }
    }

    protected IModelElement findMember(IScriptProject project, String name) throws ModelException {
        String id;
        IModelElement element;
        ILaunchConfiguration launchConfiguration;
        IScriptProject launchedProject;
        block4: {
            launchedProject = this.fTestRunner.getLaunchedProject();
            ILaunch launch = this.fTestRunner.getLaunch();
            launchConfiguration = launch.getLaunchConfiguration();
            element = null;
            id = null;
            try {
                id = launchConfiguration.getAttribute("org.eclipse.dltk.testing.engineId", "");
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (id != null) {
            ITestingElementResolver resolver = MemberResolverManager.getResolver(id);
            if (resolver == null) {
                return element;
            }
            ISourceModule module = this.resolveSourceModule(launchedProject, launchConfiguration);
            element = resolver.resolveElement(launchedProject, launchConfiguration, module, name);
            this.fRange = resolver.resolveRange(project, launchConfiguration, name, module, element, this.fMethodName);
        }
        return element;
    }
}

