/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.debug.core.model.IScriptMethodEntryBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptMethodEntryBreakpoint
extends ScriptLineBreakpoint
implements IScriptMethodEntryBreakpoint {
    private static final String METHOD_NAME = "org.eclipse.dltk.debug.methodName";
    private static final String BREAK_ON_ENTRY = "org.eclipse.dltk.debug.methodEntry";
    private static final String BREAK_ON_EXIT = "org.eclipse.dltk.debug.methodExit";
    private static final String ENTRY_ID = "org.eclipse.dltk.debug.entryBrId";
    private static final String EXIT_ID = "org.eclipse.dltk.debug.exitBrId";
    private static final String[] UPDATABLE_ATTRS = new String[]{"org.eclipse.dltk.debug.methodName", "org.eclipse.dltk.debug.methodEntry", "org.eclipse.dltk.debug.methodExit"};

    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptMethodEntryBreakpointMarker";
    }

    public ScriptMethodEntryBreakpoint() {
    }

    public ScriptMethodEntryBreakpoint(String debugModelId, IResource resource, IPath path, int lineNumber, int charStart, int charEnd, boolean register, String methodName) throws DebugException {
        super(debugModelId, resource, path, lineNumber, charStart, charEnd, register);
        try {
            this.ensureMarker().setAttribute(METHOD_NAME, (Object)methodName);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }

    public String getMethodName() throws CoreException {
        return this.ensureMarker().getAttribute(METHOD_NAME, "");
    }

    public boolean breakOnEntry() throws CoreException {
        return this.ensureMarker().getAttribute(BREAK_ON_ENTRY, false);
    }

    public void setBreakOnEntry(boolean value) throws CoreException {
        this.ensureMarker().setAttribute(BREAK_ON_ENTRY, value);
    }

    public boolean breakOnExit() throws CoreException {
        return this.ensureMarker().getAttribute(BREAK_ON_EXIT, false);
    }

    public void setBreakOnExit(boolean value) throws CoreException {
        this.ensureMarker().setAttribute(BREAK_ON_EXIT, value);
    }

    public String getEntryBreakpointId() throws CoreException {
        return this.ensureMarker().getAttribute(ENTRY_ID, null);
    }

    public void setEntryBreakpointId(String id) throws CoreException {
        this.ensureMarker().setAttribute(ENTRY_ID, (Object)id);
    }

    public String getExitBreakpointId() throws CoreException {
        return this.ensureMarker().getAttribute(EXIT_ID, null);
    }

    public void setExitBreakpointId(String id) throws CoreException {
        this.ensureMarker().setAttribute(EXIT_ID, (Object)id);
    }

    public String[] getUpdatableAttributes() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList(super.getUpdatableAttributes()));
        all.addAll(Arrays.asList(UPDATABLE_ATTRS));
        return all.toArray(new String[all.size()]);
    }
}

