/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.PositionUpdater;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlighting;
import org.eclipse.dltk.internal.ui.text.DLTKColorManager;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ScriptTextTools {
    private DLTKColorManager fColorManager;
    private String fDefaultPartitioning;
    private String[] fLegalContentTypes;

    protected ScriptTextTools(String defaultPartitioning, String[] legalContentTypes, boolean autoDisposeOnDisplayDispose) {
        this.fDefaultPartitioning = defaultPartitioning;
        this.fLegalContentTypes = legalContentTypes;
        this.fColorManager = new DLTKColorManager(autoDisposeOnDisplayDispose);
    }

    public void dispose() {
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public final ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor) {
        return this.createSourceViewerConfiguraton(preferenceStore, editor, this.fDefaultPartitioning);
    }

    public abstract ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore var1, ITextEditor var2, String var3);

    public IPartitionTokenScanner getPartitionScanner() {
        return null;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        IPartitionTokenScanner scaner = this.getPartitionScanner();
        if (scaner == null) {
            return null;
        }
        return new FastPartitioner(scaner, this.fLegalContentTypes);
    }

    public void setupDocumentPartitioner(IDocument document) {
        this.setupDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (partitioner != null) {
            partitioner.connect(document);
            if (document instanceof IDocumentExtension3) {
                IDocumentExtension3 extension3 = (IDocumentExtension3)document;
                extension3.setDocumentPartitioner(partitioning, partitioner);
            } else {
                document.setDocumentPartitioner(partitioner);
            }
        }
    }

    public SemanticHighlighting[] getSemanticHighlightings() {
        return new SemanticHighlighting[0];
    }

    public PositionUpdater getSemanticPositionUpdater() {
        return null;
    }

    public String getDefaultPartitioning() {
        return this.fDefaultPartitioning;
    }
}

