/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.text.folding.IFoldingPreferenceBlock;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class FoldingConfigurationBlock
implements IPreferenceConfigurationBlock {
    protected final OverlayPreferenceStore fStore;
    private Button fFoldingCheckbox;
    private Button fCommentsFoldingCheckbox;
    private Composite fGroup;
    private StackLayout fStackLayout;
    PreferencePage fMainPage;
    private Control fProviderControl;
    private IFoldingPreferenceBlock fPreferenceBlock;

    public FoldingConfigurationBlock(OverlayPreferenceStore store, PreferencePage prefPage) {
        Assert.isNotNull((Object)store);
        this.fMainPage = prefPage;
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fPreferenceBlock = this.createFoldingPreferenceBlock();
        this.fProviderControl = null;
    }

    protected PreferencePage getPreferencePage() {
        return this.fMainPage;
    }

    protected abstract IFoldingPreferenceBlock createFoldingPreferenceBlock();

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_comments_folding_enabled"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(32);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        PixelConverter pc = new PixelConverter((Control)composite);
        layout.verticalSpacing = pc.convertHeightInCharsToPixels(1) / 2;
        composite.setLayout((Layout)layout);
        this.fFoldingCheckbox = new Button(composite, 32);
        this.fFoldingCheckbox.setText(PreferencesMessages.FoldingConfigurationBlock_enable);
        gd = new GridData(32);
        this.fFoldingCheckbox.setLayoutData((Object)gd);
        this.fFoldingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = FoldingConfigurationBlock.this.fFoldingCheckbox.getSelection();
                FoldingConfigurationBlock.this.fStore.setValue("editor_folding_enabled", enabled);
                FoldingConfigurationBlock.this.updateCheckboxDependencies();
            }
        });
        this.createCommentsFoldingCheckbox(composite);
        Composite groupComp = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        groupComp.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        groupComp.setLayout((Layout)gridLayout);
        this.fGroup = new Composite(groupComp, 0);
        gd = new GridData(802);
        this.fGroup.setLayoutData((Object)gd);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        return composite;
    }

    protected void createCommentsFoldingCheckbox(Composite composite) {
        this.fCommentsFoldingCheckbox = new Button(composite, 32);
        this.fCommentsFoldingCheckbox.setText(PreferencesMessages.FoldingConfigurationBlock_commentsEnable);
        GridData gd = new GridData(32);
        this.fCommentsFoldingCheckbox.setLayoutData((Object)gd);
        this.fCommentsFoldingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = FoldingConfigurationBlock.this.fCommentsFoldingCheckbox.getSelection();
                FoldingConfigurationBlock.this.fStore.setValue("editor_comments_folding_enabled", enabled);
                FoldingConfigurationBlock.this.updateCheckboxDependencies();
            }
        });
    }

    private void updateCheckboxDependencies() {
        if (this.fCommentsFoldingCheckbox != null) {
            this.fCommentsFoldingCheckbox.setEnabled(this.fFoldingCheckbox.getSelection());
        }
    }

    IFoldingPreferenceBlock getPreferenceBlock() {
        return this.fPreferenceBlock;
    }

    void updateListDependencies() {
        Control control;
        IFoldingPreferenceBlock prefs = this.getPreferenceBlock();
        if (prefs == null) {
            prefs = new ErrorPreferences(PreferencesMessages.FoldingConfigurationBlock_noFoldingPreferenceBlock);
        }
        if ((control = this.fProviderControl) == null) {
            control = prefs.createControl(this.fGroup);
            if (control == null) {
                String message = PreferencesMessages.FoldingConfigurationBlock_info_no_preferences;
                control = new ErrorPreferences(message).createControl(this.fGroup);
            } else {
                this.fProviderControl = control;
            }
        }
        Dialog.applyDialogFont((Control)control);
        this.fStackLayout.topControl = control;
        control.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        prefs.initialize();
    }

    public void initialize() {
        this.restoreFromPreferences();
    }

    public void performOk() {
        IFoldingPreferenceBlock prefs = this.getPreferenceBlock();
        prefs.performOk();
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        IFoldingPreferenceBlock prefs = this.getPreferenceBlock();
        prefs.performDefaults();
    }

    public void dispose() {
        IFoldingPreferenceBlock prefs = this.getPreferenceBlock();
        prefs.dispose();
    }

    private void restoreFromPreferences() {
        boolean enabled = this.fStore.getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
        boolean commentsEnabled = this.fStore.getBoolean("editor_comments_folding_enabled");
        if (this.fCommentsFoldingCheckbox != null) {
            this.fCommentsFoldingCheckbox.setSelection(commentsEnabled);
        }
        this.updateCheckboxDependencies();
        this.updateListDependencies();
    }

    private static class ErrorPreferences
    implements IFoldingPreferenceBlock {
        private String fMessage;

        protected ErrorPreferences(String message) {
            this.fMessage = message;
        }

        public Control createControl(Composite composite) {
            Composite inner = new Composite(composite, 0);
            inner.setLayout((Layout)new FillLayout(512));
            Label label = new Label(inner, 0x1000000);
            label.setText(this.fMessage);
            return inner;
        }

        public void initialize() {
        }

        public void performOk() {
        }

        public void performDefaults() {
        }

        public void dispose() {
        }
    }
}

