/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.corext.buildpath.IPackageExplorerActionListener;
import org.eclipse.dltk.internal.corext.buildpath.PackageExplorerActionEvent;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierAction;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.BuildpathModifierQueries;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorer;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class HintTextGroup
implements IBuildpathInformationProvider,
IPackageExplorerActionListener {
    private static final int[] ACTION_ORDER;
    private StringDialogField fOutputLocationField;
    private Composite fTopComposite;
    private DialogPackageExplorerActionGroup fActionGroup;
    private DialogPackageExplorer fPackageExplorer;
    private IRunnableContext fRunnableContext;
    private IScriptProject fCurrJProject;
    private List fNewFolders;
    private HashMap fImageMap;

    static {
        int[] nArray = new int[12];
        nArray[0] = 10;
        nArray[1] = 5;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 8;
        nArray[5] = 3;
        nArray[6] = 9;
        nArray[8] = 1;
        nArray[9] = 13;
        nArray[10] = 12;
        nArray[11] = 11;
        ACTION_ORDER = nArray;
    }

    public HintTextGroup(DialogPackageExplorer packageExplorer, IRunnableContext runnableContext) {
        this.fPackageExplorer = packageExplorer;
        this.fRunnableContext = runnableContext;
        this.fCurrJProject = null;
        this.fNewFolders = new ArrayList();
        this.fImageMap = new HashMap();
    }

    public Composite createControl(Composite parent) {
        this.fTopComposite = new Composite(parent, 0);
        this.fTopComposite.setFont(parent.getFont());
        GridData gridData = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fTopComposite.setLayout((Layout)gridLayout);
        this.fTopComposite.setLayoutData((Object)gridData);
        this.fTopComposite.setData(null);
        this.fTopComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Collection collection = HintTextGroup.this.fImageMap.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
            }
        });
        return this.fTopComposite;
    }

    private Shell getShell() {
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    public void setScriptProject(IScriptProject jProject) {
        this.fCurrJProject = jProject;
    }

    public void setActionGroup(DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }

    private FormText createFormText(Composite parent, String text) {
        FormText formText;
        FormToolkit toolkit = new FormToolkit(this.getShell().getDisplay());
        try {
            FormText formText2 = toolkit.createFormText(parent, true);
            formText2.setFont(parent.getFont());
            try {
                formText2.setText(text, true, false);
            }
            catch (IllegalArgumentException e) {
                formText2.setText(e.getMessage(), false, false);
                DLTKUIPlugin.log(e);
            }
            formText2.marginHeight = 2;
            formText2.marginWidth = 0;
            formText2.setBackground(null);
            formText2.setLayoutData((Object)new TableWrapData(256));
            formText = formText2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            toolkit.dispose();
            throw throwable;
        }
        toolkit.dispose();
        return formText;
    }

    private void createLabel(Composite parent, String text, final BuildpathModifierAction action, final IRunnableContext context) {
        FormText formText = this.createFormText(parent, text);
        Image image = (Image)this.fImageMap.get(action.getId());
        if (image == null) {
            image = action.getImageDescriptor().createImage();
            this.fImageMap.put(action.getId(), image);
        }
        formText.setImage("defaultImage", image);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    context.run(false, false, (IRunnableWithProgress)action.getOperation());
                }
                catch (InvocationTargetException err) {
                    ExceptionHandler.handle(err, HintTextGroup.this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title, action.getName()), err.getMessage());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    public IStructuredSelection getSelection() {
        return this.fPackageExplorer.getSelection();
    }

    public void setSelection(List elements) {
        this.fPackageExplorer.setSelection(elements);
    }

    public IScriptProject getScriptProject() {
        return this.fCurrJProject;
    }

    public void handleResult(List resultElements, CoreException exception, int actionType) {
        if (exception != null) {
            ExceptionHandler.handle(exception, this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title_refresh, this.fActionGroup.getAction(actionType).getName()), exception.getLocalizedMessage());
            return;
        }
        switch (actionType) {
            case 10: {
                this.handleFolderCreation(resultElements);
                break;
            }
            case 5: {
                this.handleFolderCreation(resultElements);
                break;
            }
            case 4: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 0: 
            case 11: 
            case 12: 
            case 13: {
                this.handleAddToCP(resultElements);
                break;
            }
            case 1: {
                this.handleRemoveFromBP(resultElements, false);
                break;
            }
            case 8: {
                this.defaultHandle(resultElements, true);
                break;
            }
            case 2: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 9: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 3: {
                this.defaultHandle(resultElements, true);
                break;
            }
            case 7: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 6: {
                this.handleResetAll();
                break;
            }
        }
    }

    private void defaultHandle(List result, boolean forceRebuild) {
        try {
            this.fPackageExplorer.setSelection(result);
            if (forceRebuild) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleFolderCreation(List result) {
        if (result.size() == 1) {
            this.fNewFolders.add(result.get(0));
            this.fPackageExplorer.setSelection(result);
        }
    }

    private void handleAddToCP(List result) {
        try {
            if (this.containsScriptProject(result)) {
                this.fPackageExplorer.setSelection(result);
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            } else {
                this.fPackageExplorer.setSelection(result);
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleRemoveFromBP(List result, boolean forceRebuild) {
        this.fPackageExplorer.setSelection(result);
        try {
            if (forceRebuild || this.containsScriptProject(result)) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleResetAll() {
        ArrayList<IScriptProject> list = new ArrayList<IScriptProject>();
        list.add(this.fCurrJProject);
        this.setSelection(list);
    }

    private boolean containsScriptProject(List elements) {
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof IScriptProject) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public BuildpathModifierQueries.IInclusionExclusionQuery getInclusionExclusionQuery() {
        return BuildpathModifierQueries.getDefaultInclusionExclusionQuery(this.getShell());
    }

    public BuildpathModifierQueries.ILinkToQuery getLinkFolderQuery() throws ModelException {
        return BuildpathModifierQueries.getDefaultLinkQuery(this.getShell(), this.fCurrJProject, (IPath)new Path(this.fOutputLocationField.getText()));
    }

    public BuildpathModifierQueries.ICreateFolderQuery getCreateFolderQuery() throws ModelException {
        return BuildpathModifierQueries.getDefaultCreateFolderQuery(this.getShell(), this.fCurrJProject);
    }

    public BuildpathModifierQueries.IRemoveLinkedFolderQuery getRemoveLinkedFolderQuery() throws ModelException {
        return BuildpathModifierQueries.getDefaultRemoveLinkedFolderQuery(this.getShell());
    }

    public BuildpathModifierQueries.IAddArchivesQuery getExternalArchivesQuery(IEnvironment environment) throws ModelException {
        return BuildpathModifierQueries.getDefaultArchivesQuery(this.getShell(), environment);
    }

    public BuildpathModifierQueries.IAddLibrariesQuery getLibrariesQuery() throws ModelException {
        return BuildpathModifierQueries.getDefaultLibrariesQuery(this.getShell());
    }

    public void deleteCreatedResources() {
        Iterator iterator = this.fNewFolders.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            try {
                IFolder folder;
                if (element instanceof IFolder) {
                    folder = (IFolder)element;
                } else if (element instanceof IModelElement) {
                    folder = this.fCurrJProject.getProject().getWorkspace().getRoot().getFolder(((IModelElement)element).getPath());
                } else {
                    ((IFile)element).delete(false, null);
                    continue;
                }
                folder.delete(false, null);
            }
            catch (CoreException coreException) {}
        }
        this.fNewFolders = new ArrayList();
    }

    public void handlePackageExplorerActionEvent(PackageExplorerActionEvent event) {
        Composite childComposite = (Composite)this.fTopComposite.getData();
        if (childComposite != null && childComposite.getParent() != null) {
            childComposite.getParent().dispose();
        }
        ScrolledPageContent spc = new ScrolledPageContent(this.fTopComposite, 512);
        spc.getVerticalBar().setIncrement(5);
        spc.setLayoutData(new GridData(1808));
        childComposite = spc.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        childComposite.setLayout((Layout)tableWrapLayout);
        childComposite.setLayoutData((Object)new GridData(768));
        this.fTopComposite.setData((Object)childComposite);
        BuildpathModifierAction[] actions = event.getEnabledActions();
        String[] descriptionText = event.getEnabledActionsText();
        if (this.noContextHelpAvailable(actions)) {
            String noAction = this.fActionGroup.getNoActionDescription();
            this.createFormText(childComposite, Messages.format(NewWizardMessages.HintTextGroup_NoAction, noAction));
            this.fTopComposite.layout(true);
            return;
        }
        int j = 0;
        while (j < ACTION_ORDER.length) {
            int i = 0;
            while (i < actions.length) {
                int id = Integer.parseInt(actions[i].getId());
                if (id == ACTION_ORDER[j]) {
                    this.createLabel(childComposite, descriptionText[i], actions[i], this.fRunnableContext);
                    break;
                }
                ++i;
            }
            ++j;
        }
        this.fTopComposite.layout(true);
    }

    private boolean noContextHelpAvailable(BuildpathModifierAction[] actions) {
        int id;
        if (actions.length == 0) {
            return true;
        }
        if (actions.length == 1 && (id = Integer.parseInt(actions[0].getId())) == 5) {
            return true;
        }
        if (actions.length == 2) {
            int idLink = Integer.parseInt(actions[0].getId());
            int idReset = Integer.parseInt(actions[1].getId());
            if (idReset == 6 && idLink == 5) {
                return true;
            }
        }
        return false;
    }
}

