/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.TclCorrectionProcessor;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;

public class TclQuickAssistLightBulbUpdater {
    private final Annotation fAnnotation;
    private boolean fIsAnnotationShown;
    private ITextEditor fEditor;
    private ITextViewer fViewer;
    private ISelectionChangedListener fListener;
    private IPropertyChangeListener fPropertyChangeListener;

    public TclQuickAssistLightBulbUpdater(ITextEditor part, ITextViewer viewer) {
        this.fEditor = part;
        this.fViewer = viewer;
        this.fAnnotation = new AssistAnnotation();
        this.fIsAnnotationShown = false;
        this.fPropertyChangeListener = null;
    }

    public boolean isSetInPreferences() {
        return true;
    }

    private void installSelectionListener() {
        this.fListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    TclQuickAssistLightBulbUpdater.this.doSelectionChanged(textSelection.getOffset(), textSelection.getLength());
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fListener);
    }

    private void uninstallSelectionListener() {
        IAnnotationModel model;
        if (this.fListener != null) {
            this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fListener);
            this.fListener = null;
        }
        if ((model = this.getAnnotationModel()) != null) {
            this.removeLightBulb(model);
        }
    }

    public void install() {
        if (this.isSetInPreferences()) {
            this.installSelectionListener();
        }
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    TclQuickAssistLightBulbUpdater.this.doPropertyChanged(event.getProperty());
                }
            };
            TclUI.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void uninstall() {
        this.uninstallSelectionListener();
        if (this.fPropertyChangeListener != null) {
            TclUI.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
    }

    protected void doPropertyChanged(String property) {
    }

    private ISourceModule getSourceModule() {
        IModelElement elem = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)this.fEditor.getEditorInput());
        if (elem instanceof ISourceModule) {
            return (ISourceModule)elem;
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        return DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return DLTKUIPlugin.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void doSelectionChanged(int offset, int length) {
        IAnnotationModel model = this.getAnnotationModel();
        ISourceModule cu = this.getSourceModule();
        if (model == null || cu == null) {
            return;
        }
        boolean hasQuickFix = this.hasQuickFixLightBulb(model, offset);
        if (hasQuickFix) {
            this.removeLightBulb(model);
            return;
        }
        this.calculateLightBulb(model, offset, length);
    }

    private void calculateLightBulb(IAnnotationModel model, int offset, int length) {
        boolean needsAnnotation = true;
        if (this.fIsAnnotationShown) {
            model.removeAnnotation(this.fAnnotation);
        }
        if (needsAnnotation) {
            model.addAnnotation(this.fAnnotation, new Position(offset, length));
        }
        this.fIsAnnotationShown = needsAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLightBulb(IAnnotationModel model) {
        TclQuickAssistLightBulbUpdater tclQuickAssistLightBulbUpdater = this;
        synchronized (tclQuickAssistLightBulbUpdater) {
            if (this.fIsAnnotationShown) {
                model.removeAnnotation(this.fAnnotation);
                this.fIsAnnotationShown = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasQuickFixLightBulb(IAnnotationModel model, int offset) {
        try {
            int startLine;
            Position pos;
            Annotation annot;
            IDocument document = this.getDocument();
            if (document == null) {
                return false;
            }
            int currLine = document.getLineOfOffset(offset);
            Iterator iter = model.getAnnotationIterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!TclCorrectionProcessor.isQuickFixableType(annot = (Annotation)iter.next()) || (pos = model.getPosition(annot)) == null || (startLine = document.getLineOfOffset(pos.getOffset())) != currLine || !TclCorrectionProcessor.hasCorrections(annot));
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        return false;
    }

    public static class AssistAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private static final int LAYER;
        private Image fImage;

        static {
            Annotation annotation = new Annotation("org.eclipse.dltk.ui.warning", false, null);
            AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
            LAYER = preference != null ? preference.getPresentationLayer() - 1 : 0;
        }

        public int getLayer() {
            return LAYER;
        }

        private Image getImage() {
            if (this.fImage == null) {
                this.fImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.quickassist_obj.gif");
            }
            return this.fImage;
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            ImageUtilities.drawImage((Image)this.getImage(), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }
}

