/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.folding;

import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.tcl.internal.ui.text.folding.TclFoldingStructureProvider;
import org.eclipse.dltk.tcl.ui.TclPreferenceConstants;
import org.eclipse.dltk.tcl.ui.tests.TclUITestsPlugin;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class TclFoldingTest
extends TestCase {
    IPreferenceStore fStore;
    MyTclASTFoldingStructureProvider provider;

    private void installDocumentStuff(Document document) {
        String[] types = new String[]{"__tcl_string", "__tcl_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new TclPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__tcl_partitioning", (IDocumentPartitioner)partitioner);
    }

    private void removeDocumentStuff(Document document) {
        document.setDocumentPartitioner("__tcl_partitioning", null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fStore = TclUITestsPlugin.getDefault().getPreferenceStore();
        TclPreferenceConstants.initializeDefaultValues((IPreferenceStore)this.fStore);
        this.provider = new MyTclASTFoldingStructureProvider();
    }

    public void test0() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = "#ab\n#dc\n";
        Document document = new Document(content);
        this.installDocumentStuff(document);
        this.provider.setDocument(document);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        TclFoldingTest.assertEquals((int)1, (int)result.size());
        this.removeDocumentStuff(document);
    }

    public void test1() throws Exception {
        String content = "#ab\n\n#dc\n";
        Document document = new Document(content);
        this.installDocumentStuff(document);
        this.provider.setDocument(document);
        this.fStore.setValue("editor_folding_comments_lines", false);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        TclFoldingTest.assertEquals((int)0, (int)result.size());
        this.removeDocumentStuff(document);
    }

    public void test2() throws Exception {
        String content = "#ab\n\n#dc\n";
        Document document = new Document(content);
        this.installDocumentStuff(document);
        this.provider.setDocument(document);
        this.fStore.setValue("editor_folding_comments_lines", true);
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        TclFoldingTest.assertEquals((int)1, (int)result.size());
        this.removeDocumentStuff(document);
    }

    public void test3() throws Exception {
        this.fStore.setValue("editor_folding_lines_limit", 2);
        String content = " namespace eval NM {\n    # headercomment\n    # here\n    # ...\n}\nproc foo {} {\n    if $a {\n       doo\n       doo2\n       anothercmdblock xxx {\n            #...\n       }\n    }\n}\n";
        Document document = new Document(content);
        this.installDocumentStuff(document);
        this.provider.setDocument(document);
        this.fStore.setValue("editor_folding_comments_lines", true);
        this.fStore.setValue("editor_folding_blocks", 2);
        this.fStore.setValue("editor_folding_exclude_list", "");
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        TclFoldingTest.assertEquals((int)4, (int)result.size());
        this.removeDocumentStuff(document);
    }

    public void test4() throws Exception {
        String content = "namespace eval NM {\n    # headercomment\n    # here\n    # ...\n}\nproc foo {} {\n    if $a {\n       doo\n       doo2\n       anothercmdblock xxx {\n            #...\n       }\n    }\n}\n";
        Document document = new Document(content);
        this.installDocumentStuff(document);
        this.provider.setDocument(document);
        this.fStore.setValue("editor_folding_comments_lines", true);
        this.fStore.setValue("editor_folding_blocks", 1);
        this.fStore.setValue("editor_folding_include_list", "anothercmdblock");
        Map result = this.provider.testComputeFoldingStructure(content, this.provider.createInitialContext());
        TclFoldingTest.assertEquals((int)1, (int)result.size());
        this.removeDocumentStuff(document);
    }

    private class MyTclASTFoldingStructureProvider
    extends TclFoldingStructureProvider {
        Document fDocument;

        private MyTclASTFoldingStructureProvider() {
        }

        protected AbstractASTFoldingStructureProvider.FoldingStructureComputationContext createInitialContext() {
            this.initializePreferences(TclFoldingTest.this.fStore);
            return this.createContext(true);
        }

        protected AbstractASTFoldingStructureProvider.FoldingStructureComputationContext createContext(boolean allowCollapse) {
            ProjectionAnnotationModel model = new ProjectionAnnotationModel();
            IDocument doc = this.getDocument();
            if (doc == null) {
                return null;
            }
            return new AbstractASTFoldingStructureProvider.FoldingStructureComputationContext((AbstractASTFoldingStructureProvider)this, doc, model, allowCollapse);
        }

        public void setDocument(Document doc) {
            this.fDocument = doc;
        }

        protected IDocument getDocument() {
            return this.fDocument;
        }

        public Map testComputeFoldingStructure(String contents, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
            super.computeFoldingStructure(contents, ctx);
            return ctx.getMap();
        }
    }
}

