/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.ui.tests.indenting;

import org.eclipse.dltk.python.internal.ui.text.PythonAutoEditStrategy;
import org.eclipse.dltk.python.internal.ui.text.PythonPartitionScanner;
import org.eclipse.dltk.python.ui.PythonPreferenceConstants;
import org.eclipse.dltk.python.ui.tests.PythonUITestsPlugin;
import org.eclipse.dltk.python.ui.tests.indenting.DocCmd;
import org.eclipse.dltk.python.ui.tests.indenting.PyUITest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class PyAutoIndentStrategyTest
extends PyUITest {
    private PythonAutoEditStrategy strategy;
    private String doc;
    private DocCmd docCmd;
    private String expected;
    IPreferenceStore fStore;

    private void installStuff(Document document) {
        String[] types = new String[]{"__python_string", "__python_comment", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PythonPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__python_partitioning", (IDocumentPartitioner)partitioner);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fStore = PythonUITestsPlugin.getDefault().getPreferenceStore();
        PythonPreferenceConstants.initializeDefaultValues((IPreferenceStore)this.fStore);
        String fPartitioning = "__python_partitioning";
        this.strategy = new PythonAutoEditStrategy(this.fStore, fPartitioning);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testTab() {
        System.out.println("Tab\n");
        String str = "        args = [ '-1', '-2',\n                ";
        DocCmd docCmd = new DocCmd(str.length(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(str), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\t", (String)docCmd.text);
    }

    public void _testSpaces() {
        System.out.println("Spaces\n");
        DocCmd docCmd = new DocCmd(0, 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    ", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "\t\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"        ", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "\tabc");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    abc", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "\tabc\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    abc    ", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)" ", (String)docCmd.text);
    }

    public void testNewLineAfterReturn() {
        System.out.println("NewLineAfterReturn\n");
        System.out.println("NewLineAfterReturn\n");
        String str = "def m1(self):\n    return 'foo'\n#ffo";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "#ffo".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testIgnoreComment() {
        System.out.println("IgnoreComment\n");
        String str = "titleEnd = ('[#')";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testIgnoreComment2() {
        System.out.println("IgnoreComment2\n");
        String str = "titleEnd = ('''\n            [#''')";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void _testNewLineAfterOpeningParWithOtherContents() {
        System.out.println("NewLineAfterOpeningParWithOtherContents\n");
        String str = "def m1(  self,";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n         ", (String)docCmd.text);
    }

    public void _testNewLineAfterReturn2() {
        System.out.println("NewLineAfterReturn2\n");
        String str = "def m1(self):\n    return ('foo',";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n            ", (String)docCmd.text);
    }

    public void testMaintainIndent() {
        System.out.println("MaintainIndent\n");
        String str = "def moo():\n    if not 1:\n        print 'foo'\n    print 'bla'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "print 'bla'".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    ", (String)docCmd.text);
    }

    public void _testMaintainIndent2() {
        System.out.println("MaintainIndent2\n");
        String str = "def moo():\n    if not 1:\n        print 'foo'\n    print 'bla'";
        Document doc = new Document(str);
        int offset = doc.getLength() - "  print 'bla'".length();
        DocCmd docCmd = new DocCmd(offset, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n  ", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)(offset + 2), (int)docCmd.caretOffset);
    }

    public void testDontChangeCursorOffset() {
        System.out.println("DontChangeCursorOffset\n");
        String str = "def moo():\n    if not 1:\n        print    'foo'";
        Document doc = new Document(str);
        int offset = doc.getLength() - "    'foo'".length();
        DocCmd docCmd = new DocCmd(offset, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n        ", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)-1, (int)docCmd.caretOffset);
    }

    public void testTabIndentToLevel() {
        System.out.println("TabIndentToLevel\n");
        String str = "properties.create( \n                  a,\n        \n\n                  b,\n)";
        Document doc = new Document(str);
        int offset = doc.getLength() - "\n                  b,\n)".length();
        DocCmd docCmd = new DocCmd(offset, 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"                  ", (String)docCmd.text);
    }

    public void _testTabIndentToLevel2() {
        System.out.println("TabIndentToLevel2\n");
        String str = "class ContaminantFont( Barrier, ModelBase ):\n    '''\n    This class contains information to edit a contaminant.\n    '''\n    properties.create( \n                          \n                          #defines where is the source (in the water or in the soil)\n                          sourceLocation = SOURCE_LOCATION_WATER,\n                          \n";
        Document doc = new Document(str);
        int offset = doc.getLength();
        DocCmd docCmd = new DocCmd(offset, 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    ", (String)docCmd.text);
    }

    public void testTabIndentToLevel3() {
        System.out.println("TabIndentToLevel3\n");
        String str = "class ContaminantFont( Barrier, ModelBase ):\n    '''\n    This class contains information to edit a contaminant.\n    '''\n    properties.create( \n                          \n                          #defines where is the source (in the water or in the soil)\n                          sourceLocation = SOURCE_LOCATION_WATER,\n                          \n    ";
        Document doc = new Document(str);
        int offset = doc.getLength();
        DocCmd docCmd = new DocCmd(offset, 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"                          ", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)(offset - 4), (int)docCmd.offset);
        PyAutoIndentStrategyTest.assertEquals((int)4, (int)docCmd.length);
    }

    public void testNoAutoIndentClosingPar() {
        System.out.println("NoAutoIndentClosingPar\n");
        String str = "newTuple = (\n              what(),\n            )\n";
        Document doc = new Document(str);
        String s = "\n            )\n";
        DocCmd docCmd = new DocCmd(doc.getLength() - s.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n              ", (String)docCmd.text);
    }

    public void testNoAutoIndentClosingPar2() {
        System.out.println("NoAutoIndentClosingPar2\n");
        String str = "newTuple = (\n              what(),\n\n            )\n";
        Document doc = new Document(str);
        String s = "\n            )\n";
        DocCmd docCmd = new DocCmd(doc.getLength() - s.length(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"              ", (String)docCmd.text);
    }

    public void testNewLineAfterLineWithComment() {
        System.out.println("NewLineAfterLineWithComment\n");
        String str = "string1 = '01234546789[#]'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testNewLine10() {
        System.out.println("NewLine10\n");
        String str = "def M1(a):\n    doFoo(a,b(),\n          '',b)";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    ", (String)docCmd.text);
    }

    public void testNewLine11() {
        System.out.println("NewLine11\n");
        String str = "def fun():\n    if True:\n        passif False: 'foo'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "if False: 'foo'".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    ", (String)docCmd.text);
    }

    public void testNewLine12() {
        System.out.println("NewLine12\n");
        String str = "if False:print 'done'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "print 'done'".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n\t", (String)docCmd.text);
    }

    public void testNewLine3() {
        System.out.println("NewLine3\n");
        String str = "for a in b:    ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - 4, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n\t", (String)docCmd.text);
        String expected = "for a in b:    ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)doc.get());
    }

    public void testNewLine6() {
        System.out.println("NewLine6\n");
        String str = "for v in w:\n    pass\n";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testNewLine6a() {
        System.out.println("NewLine6a\n");
        String str = "def getSpilledComps( *dummy ):\n    return [self.component4]";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testNewLine7() {
        System.out.println("NewLine7\n");
        String str = "class C:\n    a = 30\nprint C.a\n\n";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testNewLine8() {
        System.out.println("NewLine8\n");
        String str = "class C:\n    pass\n    a = 30\n    ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    ", (String)docCmd.text);
    }

    public void testIndent() {
        System.out.println("Indent\n");
        String str = "while False:\n    if foo:";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "if foo:".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    ", (String)docCmd.text);
    }

    public void testIndentAfterRet() {
        System.out.println("IndentAfterRet\n");
        String str = "class Foo:\n    def m1():\n        for a in b:\n            if a = 20:\n                print 'foo'\n        return 30\n    ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    ", (String)docCmd.text);
    }

    public void testIndentAfterRet2() {
        System.out.println("IndentAfterRet2\n");
        String str = "class Foo:\n    def m1():\n        for a in b:\n            if a = 20:\n                print 'foo'\n        return 30\n    \n";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    ", (String)docCmd.text);
    }

    public void testNewLine9() {
        System.out.println("NewLine9\n");
        String str = "class C:\n    try:";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n    \t", (String)docCmd.text);
    }

    public void testNewLine4() {
        System.out.println("NewLine4\n");
        String str = "def a():\n    print a";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "    print a".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = "def a():\n    print a";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)doc.get());
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void _testNewLine5() {
        System.out.println("NewLine5\n");
        String str = "def a():\n    ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "    ".length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = "def a():\n    ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)doc.get());
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testNewLine() {
        System.out.println("NewLine\n");
        String str = "createintervention() #create ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testNewLine2() {
        System.out.println("NewLine2\n");
        String str = "err)";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\n", (String)docCmd.text);
    }

    public void testTabInComment() {
        System.out.println("TabInComment\n");
        String str = "#comment";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\t", (String)docCmd.text);
    }

    public void testIndentingWithTab() {
        System.out.println("IndentingWithTab\n");
        String str = "class C:\n    def m1(self):\n";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    \t", (String)docCmd.text);
    }

    public void testIndentingWithTab2() {
        System.out.println("IndentingWithTab2\n");
        String str = "class C:\n    pass\n";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\t", (String)docCmd.text);
    }

    public void testIndentingWithTab3() {
        System.out.println("IndentingWithTab3\n");
        String str = "class C:\n    def m1(self):            \n        print 1\n";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"        ", (String)docCmd.text);
    }

    public void testIndentingWithTab4() {
        System.out.println("IndentingWithTab4\n");
        String str = "class C:\n    def m1(self):            \n        print 'a'\n        ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\t", (String)docCmd.text);
    }

    public void testIndentingWithTab5() {
        System.out.println("IndentingWithTab5\n");
        String str = "class C:\n    def m1(self):            \n        print 'a'\n       ";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"        ", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)"       ".length(), (int)docCmd.length);
        PyAutoIndentStrategyTest.assertEquals((int)(doc.getLength() - "       ".length()), (int)docCmd.offset);
    }

    public void testIndentingWithTab6() {
        System.out.println("IndentingWithTab6\n");
        String str = "class C:\n    def m1(self):            \nprint 'a'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "print 'a'".length(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    \t", (String)docCmd.text);
    }

    public void testIndentingWithTab7() {
        System.out.println("IndentingWithTab7\n");
        String str = "class C:\n    def m1(self):            \n  print 'a'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - "  print 'a'".length(), 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"    \t", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)2, (int)docCmd.length);
    }

    public void _testTabs() {
        System.out.println("Tabs\n");
        DocCmd docCmd = new DocCmd(0, 0, "\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\t", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "\t\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\t\t", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "\tabc");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\tabc", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "\tabc\t");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\tabc\t", (String)docCmd.text);
        docCmd = new DocCmd(0, 0, "    abc");
        this.strategy.customizeDocumentCommand((IDocument)new Document(""), (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"\tabc", (String)docCmd.text);
    }

    public void testCommentsIndent() {
        System.out.println("CommentsIndent\n");
        this.doc = "class c: #some comment";
        this.docCmd = new DocCmd(this.doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(this.doc), (DocumentCommand)this.docCmd);
        this.expected = "\n\t";
        PyAutoIndentStrategyTest.assertEquals((String)this.expected, (String)this.docCmd.text);
    }

    public void _testCommentsIndent2() {
        System.out.println("CommentsIndent2\n");
        this.doc = "    # comment:";
        this.docCmd = new DocCmd(this.doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(this.doc), (DocumentCommand)this.docCmd);
        this.expected = "\n    ";
        PyAutoIndentStrategyTest.assertEquals((String)this.expected, (String)this.docCmd.text);
        this.doc = "    if False:";
        this.docCmd = new DocCmd(this.doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(this.doc), (DocumentCommand)this.docCmd);
        this.expected = "\n        ";
        PyAutoIndentStrategyTest.assertEquals((String)this.expected, (String)this.docCmd.text);
    }

    public void testIndentLevel3() {
        System.out.println("IndentLevel3\n");
        String doc = "a = (1, \n  2,";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n  ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testIndentLevel() {
        System.out.println("IndentLevel\n");
        String doc = "def m1(): #some comment\n    print foo(a,\n              b)";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n    ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testIndentLevel2() {
        System.out.println("IndentLevel2\n");
        String doc = "def m1(): #some comment\n    def metfoo(a,\n               b):";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n    \t";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testDedent() {
        System.out.println("Dedent\n");
        String doc = "def m1(): #some comment\n    return 10";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "def m1(): #some comment\n    return";
        docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "\n";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "def m1(): #some comment\n    returnIs10 = 10";
        docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "\n    ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testIndentSpaces() {
        System.out.println("IndentSpaces\n");
        String doc = "class c:";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n\t";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "    a = 2";
        docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "\n    ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void _testAfterClosePar1() {
        System.out.println("AfterClosePar1\n");
        String doc = "m = [a,";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n     ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testAfterClosePar2() {
        System.out.println("AfterClosePar2\n");
        String doc = "m = [a,\n     b,";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n     ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void _testAfterClosePar() {
        System.out.println("AfterClosePar\n");
        String doc = "m = [a, (#comment";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n         ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void _testIndent2() {
        System.out.println("Indent2\n");
        String doc = "m = [a, otherCall(), ";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        String expected = "\n      ";
        doc = "def m2(self):\n    m1(a, b(), )";
        docCmd = new DocCmd(doc.length() - 1, 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "\n       ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void _testIndent3() {
        System.out.println("Indent3\n");
        String doc = "properties.create(a = newClass(),";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n                  ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testIndent3a() {
        System.out.println("Indent3a\n");
        String doc = "properties.create(a = newClass(),\n                  b = newClass(),";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n                  ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void _testIndent4() {
        System.out.println("Indent4\n");
        String doc = "properties.create(a = newClass(),\n                  b = newClass(";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n                               ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testDedent5() {
        System.out.println("Dedent5\n");
        String doc = "properties.create(a = newClass(),\n                  b = newClass(\n                               )";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "\n");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "\n                  ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void testAutoClose() {
        System.out.println("AutoClose\n");
        String doc = "class c(object): ";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "[");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "[]";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }

    public void _testAutoPar() {
        System.out.println("AutoPar\n");
        String doc = "class c";
        DocCmd docCmd = new DocCmd(doc.length(), 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = "():";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "class c:\n    def met";
        docCmd = new DocCmd(doc.length(), 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "(self):";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "class c:\n\tdef met";
        docCmd = new DocCmd(doc.length(), 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "(self):";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "class c(object): #";
        docCmd = new DocCmd(doc.length(), 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "(";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "def a";
        docCmd = new DocCmd(doc.length(), 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "():";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "a";
        docCmd = new DocCmd(doc.length(), 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "()";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "a()";
        docCmd = new DocCmd(doc.length() - 1, 0, "(");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "(";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "def something():";
        docCmd = new DocCmd(doc.length() - 1, 0, ":");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)15, (int)docCmd.offset);
        doc = "class c:\n    def __init__(self):";
        docCmd = new DocCmd(doc.length() - 1, 0, ":");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)32, (int)docCmd.caretOffset);
        doc = "class c:\n    def __init__(self)";
        docCmd = new DocCmd(doc.length(), 0, ":");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = ":";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)31, (int)docCmd.offset);
        doc = "class c:\n    def __init__(self): # comment";
        docCmd = new DocCmd(doc.length() - 11, 0, ":");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)32, (int)docCmd.caretOffset);
        doc = "class c:\n    def __init__(self)";
        docCmd = new DocCmd(doc.length(), 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = ")";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)0, (int)docCmd.caretOffset);
        doc = "class c:\n    def __init__(self)";
        docCmd = new DocCmd(doc.length() - 1, 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)31, (int)docCmd.caretOffset);
        doc = "def __init__(self):\n   pass";
        docCmd = new DocCmd(17, 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)18, (int)docCmd.caretOffset);
        doc = "()";
        docCmd = new DocCmd(1, 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)2, (int)docCmd.caretOffset);
        doc = "() ";
        docCmd = new DocCmd(1, 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)2, (int)docCmd.caretOffset);
        doc = "(() ";
        docCmd = new DocCmd(2, 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = ")";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)0, (int)docCmd.caretOffset);
        doc = "[] ";
        docCmd = new DocCmd(1, 0, "]");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)2, (int)docCmd.caretOffset);
        doc = "([)";
        docCmd = new DocCmd(2, 0, "]");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = "]";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)0, (int)docCmd.caretOffset);
    }

    public void testParens() {
        System.out.println("Parens\n");
        String str = "isShown() #suite()";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - ") #suite()".length(), 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)9, (int)docCmd.caretOffset);
    }

    public void testParens2() {
        System.out.println("Parens2\n");
        String str = "isShown() #suite()'";
        Document doc = new Document(str);
        DocCmd docCmd = new DocCmd(doc.getLength() - ") #suite()'".length(), 0, ")");
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        PyAutoIndentStrategyTest.assertEquals((String)"", (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)9, (int)docCmd.caretOffset);
    }

    public void testElse() {
        System.out.println("Else\n");
        String strDoc = "if foo:\n    print a\n    else";
        int initialOffset = strDoc.length();
        DocCmd docCmd = new DocCmd(initialOffset, 0, ":");
        Document doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = ":";
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)(initialOffset - 4));
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((String)"if foo:\n    print a\nelse", (String)doc.get());
        strDoc = "if foo:\n    if somethingElse:        print a\n    else";
        initialOffset = strDoc.length();
        docCmd = new DocCmd(initialOffset, 0, ":");
        doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        expected = ":";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)initialOffset);
        PyAutoIndentStrategyTest.assertEquals((String)"if foo:\n    if somethingElse:        print a\n    else", (String)doc.get());
    }

    public void _testElif() {
        System.out.println("Elif\n");
        String strDoc = "if foo:\n    print a\n    elif";
        int initialOffset = strDoc.length();
        DocCmd docCmd = new DocCmd(initialOffset, 0, " ");
        Document doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = " ";
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)(initialOffset - 4));
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((String)"if foo:\n    print a\nelif", (String)doc.get());
        strDoc = "if foo:\n    if somethingElse:        print a\n    elif";
        initialOffset = strDoc.length();
        docCmd = new DocCmd(initialOffset, 0, " ");
        doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)initialOffset);
        PyAutoIndentStrategyTest.assertEquals((String)"if foo:\n    if somethingElse:        print a\n    elif", (String)doc.get());
    }

    public void testElseInFor() {
        System.out.println("ElseInFor\n");
        String strDoc = "for i in []:\n    msg=\"success at %s\" % i\n    else";
        int initialOffset = strDoc.length();
        DocCmd docCmd = new DocCmd(initialOffset, 0, ":");
        Document doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = ":";
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)(initialOffset - 4));
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((String)"for i in []:\n    msg=\"success at %s\" % i\nelse", (String)doc.get());
    }

    public void testElseInTry() {
        System.out.println("ElseInTry\n");
        String strDoc = "try:\n    print a\nexcept:\n    pass\n    else";
        int initialOffset = strDoc.length();
        DocCmd docCmd = new DocCmd(initialOffset, 0, ":");
        Document doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = ":";
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)(initialOffset - 4));
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((String)"try:\n    print a\nexcept:\n    pass\nelse", (String)doc.get());
    }

    public void _testElifWithPar() {
        System.out.println("ElifWithPar\n");
        String strDoc = "if foo:\n    print a\n    elif";
        int initialOffset = strDoc.length();
        DocCmd docCmd = new DocCmd(initialOffset, 0, "(");
        Document doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        String expected = "()";
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)(initialOffset - 4));
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((String)"if foo:\n    print a\nelif", (String)doc.get());
        strDoc = "if foo:\n    if somethingElse:        print a\n    elif";
        initialOffset = strDoc.length();
        docCmd = new DocCmd(initialOffset, 0, "(");
        doc = new Document(strDoc);
        this.strategy.customizeDocumentCommand((IDocument)doc, (DocumentCommand)docCmd);
        expected = "()";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        PyAutoIndentStrategyTest.assertEquals((int)docCmd.offset, (int)initialOffset);
        PyAutoIndentStrategyTest.assertEquals((String)"if foo:\n    if somethingElse:        print a\n    elif", (String)doc.get());
    }

    public void _testAutoImportStr() {
        System.out.println("AutoImportStr\n");
        String doc = "from xxx";
        DocCmd docCmd = new DocCmd(doc.length(), 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        String expected = " import ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "from xxx import";
        docCmd = new DocCmd(doc.length(), 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "no from xxx";
        docCmd = new DocCmd(doc.length(), 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "From xxx";
        docCmd = new DocCmd(doc.length(), 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "from this space";
        docCmd = new DocCmd(doc.length(), 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "from";
        docCmd = new DocCmd(doc.length(), 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "from xxx import yyy";
        docCmd = new DocCmd(8, 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
        doc = "from xxx #import yyy";
        docCmd = new DocCmd(8, 0, " ");
        this.strategy.customizeDocumentCommand((IDocument)new Document(doc), (DocumentCommand)docCmd);
        expected = " import ";
        PyAutoIndentStrategyTest.assertEquals((String)expected, (String)docCmd.text);
    }
}

