/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.python.tests.model.TestProgressMonitor;

public class DeleteTests
extends ModifyingResourceTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    static /* synthetic */ Class class$0;

    public DeleteTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createScriptProject("P", PYTHON_NATURE, new String[]{""});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.deleteProject("P");
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.DeleteTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField1() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  field=5;\n  pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IField field = cu.getType("X").getField("field");
            this.startDeltas();
            this.assertDeletion((IModelElement)field);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfield[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField2() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  field=5;\n  pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IField field = cu.getType("X").getField("field");
            boolean isCanceled = false;
            try {
                TestProgressMonitor monitor = TestProgressMonitor.getInstance();
                monitor.setCancelledCounter(1);
                this.getScriptModel().delete(new IModelElement[]{field}, false, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                isCanceled = true;
            }
            DeleteTests.assertTrue((String)"Operation should have thrown an operation canceled exception", (boolean)isCanceled);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteField3() throws CoreException {
        try {
            IFile file = this.createFile("P/X.py", "class X:\n  field = 5;\n  pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            final IField field = cu.getType("X").getField("field");
            this.startDeltas();
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    DeleteTests.this.assertDeletion((IModelElement)field);
                }
            }, (ISchedulingRule)file, 1, null);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfield[-]: {}");
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteMethod() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  def foo(self):\n    pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IMethod method = cu.getType("X").getMethod("foo");
            this.startDeltas();
            this.assertDeletion((IModelElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorField() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  field=\n    pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IField field = cu.getType("X").getField("field");
            this.startDeltas();
            this.assertDeletion((IModelElement)field);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfield[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    private void assertDeletion(IModelElement element) throws ModelException {
        this.assertDeletion(new IModelElement[]{element});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorInMethod1() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  def foo(self):\n    s = \n    print s\n  pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IMethod method = cu.getType("X").getMethod("foo");
            this.startDeltas();
            this.assertDeletion((IModelElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorInMethod2() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  def foo() \n    pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IMethod method = cu.getType("X").getMethod("foo");
            this.startDeltas();
            this.assertDeletion((IModelElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorInMethod3() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  def foo(self: \n    pass\n  pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IMethod method = cu.getType("X").getMethod("foo");
            this.startDeltas();
            this.assertDeletion((IModelElement)method);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[*]: {CHILDREN | FINE GRAINED}\n\t\t\t\t\tfoo()[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteSyntaxErrorType() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n  def method(self):\n  pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IType type = cu.getType("X");
            this.startDeltas();
            this.assertDeletion((IModelElement)type);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteType1() throws CoreException {
        try {
            this.createFile("P/X.py", "class X:\n    pass");
            ISourceModule cu = this.getSourceModule("P/X.py");
            IType type = cu.getType("X");
            this.startDeltas();
            this.assertDeletion((IModelElement)type);
            this.assertDeltas("Unexpected delta", "P[*]: {CHILDREN}\n\t<project root>[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteFile("P/X.py");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteType2() throws CoreException {
        try {
            this.createScriptProject("P1", PYTHON_NATURE, new String[]{"src", "bin"});
            this.createFile("P1/src/X.py", "class X:\n    pass");
            ISourceModule cu = this.getSourceModule("P1/src/X.py");
            IType type = cu.getType("X");
            this.startDeltas();
            this.assertDeletion((IModelElement)type);
            this.assertDeltas("Unexpected delta", "P1[*]: {CHILDREN}\n\tsrc[*]: {CHILDREN}\n\t\t<default>[*]: {CHILDREN}\n\t\t\tX.py[*]: {CHILDREN | FINE GRAINED | PRIMARY RESOURCE}\n\t\t\t\tX[-]: {}");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.stopDeltas();
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.stopDeltas();
        this.deleteProject("P1");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeleteWithInvalidInput() throws CoreException {
        IType type = null;
        try {
            try {
                this.createFile("P/X.py", "class X:\n    pass");
                ISourceModule cu = this.getSourceModule("P/X.py");
                type = cu.getType("X");
                this.getScriptModel().delete(null, false, null);
            }
            catch (ModelException e) {
                DeleteTests.assertTrue((String)"Should be an no elements to process: null supplied", (e.getStatus().getCode() == 968 ? 1 : 0) != 0);
                try {
                    this.getScriptModel().delete(new IModelElement[]{type}, false, null);
                }
                catch (ModelException e2) {
                    DeleteTests.assertTrue((String)"Should be an no elements to process: null in the array supplied", (e2.getStatus().getCode() == 968 ? 1 : 0) != 0);
                }
                Object var4_5 = null;
                this.deleteFile("P/X.py");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.deleteFile("P/X.py");
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        this.deleteFile("P/X.py");
    }
}

