/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceManipulation;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.tests.model.CopyMoveTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;

public class CopyMoveResourcesTests
extends CopyMoveTests {
    private static final String[] PYTHON_NATURE = new String[]{"org.eclipse.dltk.python.core.nature"};
    static /* synthetic */ Class class$0;

    public CopyMoveResourcesTests(String name) {
        super("org.eclipse.dltk.python.tests", name);
    }

    public IModelElement copyPositive(IModelElement element, IModelElement container, IModelElement sibling, String rename, boolean force) throws ModelException {
        IModelElement iModelElement;
        try {
            this.startDeltas();
            if (force) {
                IModelElement collision = this.generateHandle(element, rename, container);
                CopyMoveResourcesTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
            }
            ((ISourceManipulation)element).copy(container, sibling, rename, force, null);
            CopyMoveResourcesTests.assertTrue((String)"The original element must still exist", (boolean)element.exists());
            IModelElement copy = this.generateHandle(element, rename, container);
            CopyMoveResourcesTests.assertTrue((String)"Copy should exist", (boolean)copy.exists());
            if (element.getElementType() > 5) {
                this.ensureCorrectPositioning((IParent)container, sibling, copy);
            } else {
                container.getElementType();
            }
            IModelElementDelta destDelta = this.getDeltaFor(container, true);
            CopyMoveResourcesTests.assertTrue((String)"Destination container not changed", (destDelta != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
            IModelElementDelta[] deltas = destDelta.getAddedChildren();
            boolean found = false;
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getElement().equals(copy)) {
                    found = true;
                }
                ++i;
            }
            CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)found);
            iModelElement = copy;
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.stopDeltas();
            throw throwable;
        }
        this.stopDeltas();
        return iModelElement;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void movePositive(IModelElement[] elements, IModelElement[] destinations, IModelElement[] siblings, String[] names, boolean force, IProgressMonitor monitor) throws ModelException {
        try {
            int i;
            this.startDeltas();
            if (force) {
                i = 0;
                while (i < elements.length) {
                    IModelElement e = elements[i];
                    IModelElement collision = null;
                    collision = names == null ? this.generateHandle(e, null, destinations[i]) : this.generateHandle(e, names[i], destinations[i]);
                    CopyMoveResourcesTests.assertTrue((String)"Collision does not exist", (boolean)collision.exists());
                    ++i;
                }
            }
            this.getScriptModel().move(elements, destinations, siblings, names, force, monitor);
            i = 0;
            while (i < elements.length) {
                IModelElementDelta[] deltas;
                IModelElement element = elements[i];
                IModelElement moved = null;
                moved = names == null ? this.generateHandle(element, null, destinations[i]) : this.generateHandle(element, names[i], destinations[i]);
                if (!(destinations[i].equals(element.getParent()) || element.getElementType() == 5 && ((ISourceModule)element).isWorkingCopy())) {
                    CopyMoveResourcesTests.assertTrue((String)"The original element must not exist", (!element.exists() ? 1 : 0) != 0);
                }
                CopyMoveResourcesTests.assertTrue((String)"Moved element should exist", (boolean)moved.exists());
                IModelElementDelta destDelta = null;
                if (this.isMainType(element, destinations[i]) && names != null && names[i] != null) {
                    destDelta = this.getDeltaFor(moved.getParent());
                    CopyMoveResourcesTests.assertTrue((String)"Renamed compilation unit as result of main type not added", (destDelta != null && destDelta.getKind() == 1 ? 1 : 0) != 0);
                    deltas = destDelta.getAddedChildren();
                    CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)deltas[0].getElement().equals(moved));
                    CopyMoveResourcesTests.assertTrue((String)"flag should be F_MOVED_FROM", ((deltas[0].getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                    CopyMoveResourcesTests.assertTrue((String)"moved from handle should be original", (boolean)deltas[0].getMovedFromElement().equals(element));
                } else {
                    IModelElementDelta pkgDelta;
                    destDelta = this.getDeltaFor(destinations[i], true);
                    CopyMoveResourcesTests.assertTrue((String)"Destination container not changed", (destDelta != null && destDelta.getKind() == 4 ? 1 : 0) != 0);
                    deltas = destDelta.getAddedChildren();
                    int j = 0;
                    while (true) {
                        if (j >= deltas.length - 1) {
                            pkgDelta = deltas[deltas.length - 1];
                            CopyMoveResourcesTests.assertTrue((String)"Added children not correct for element copy", (boolean)pkgDelta.getElement().equals(moved));
                        }
                        IModelElement pkg = deltas[j].getElement();
                        CopyMoveResourcesTests.assertTrue((String)"Side effect child should be a package fragment", (pkg.getElementType() == 4 ? 1 : 0) != 0);
                        CopyMoveResourcesTests.assertTrue((String)"Side effect child should be an enclosing package", (boolean)element.getElementName().startsWith(pkg.getElementName()));
                        ++j;
                    }
                    CopyMoveResourcesTests.assertTrue((String)"flag should be F_MOVED_FROM", ((pkgDelta.getFlags() & 0x10) > 0 ? 1 : 0) != 0);
                    CopyMoveResourcesTests.assertTrue((String)"moved from handle shoud be original", (boolean)pkgDelta.getMovedFromElement().equals(element));
                    IModelElementDelta sourceDelta = this.getDeltaFor(element, true);
                    CopyMoveResourcesTests.assertTrue((String)"moved to handle should be original", (boolean)sourceDelta.getMovedToElement().equals(moved));
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.stopDeltas();
            throw throwable;
        }
        {
            Object var14_17 = null;
        }
        this.stopDeltas();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createScriptProject("P", PYTHON_NATURE, new String[]{"src", "src2", "bin"});
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.python.tests.model.CopyMoveResourcesTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new SuiteOfTestCases.Suite((Class)clazz);
    }

    public void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCopyCUAndType() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.copyNegative(new IModelElement[]{cuSource, cuSource.getType("X")}, new IModelElement[]{cuSource.getParent(), cuSource}, null, new String[]{"Y.py", "Y"}, false, 967);
    }

    public void testCopyCUForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.py", "package p2;\nclass X:\n    pass");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IModelElement)cuSource, (IModelElement)pkgDest, null, null, true);
    }

    public void testCopyCURename() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IModelElement)cuSource, (IModelElement)pkgDest, null, "Y.py", false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyCUReadOnly() throws CoreException {
        IFile file2;
        block6: {
            IFile file = null;
            file2 = null;
            try {
                this.createFolder("/P/src/p1");
                file = this.createFile("/P/src/p1/X.py", "class X:\n    pass");
                this.setReadOnly((IResource)file, true);
                ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
                this.createFolder("/P/src/p2");
                IScriptFolder pkgDest = this.getPackage("/P/src/p2");
                this.copyPositive((IModelElement)cuSource, (IModelElement)pkgDest, null, null, false);
                file2 = this.getFile("/P/src/p2/X.py");
                CopyMoveResourcesTests.assertTrue((String)"Destination cu should be read-only", (boolean)file2.isReadOnly());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (file != null) {
                    this.setReadOnly((IResource)file, false);
                }
                if (file2 != null) {
                    this.setReadOnly((IResource)file2, false);
                }
                this.deleteFolder("/P/src/p1");
                this.deleteFolder("/P/src/p2");
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (file == null) break block6;
            }
            this.setReadOnly((IResource)file, false);
        }
        if (file2 != null) {
            this.setReadOnly((IResource)file2, false);
        }
        this.deleteFolder("/P/src/p1");
        this.deleteFolder("/P/src/p2");
    }

    public void testCopyCURenameForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/Y.py", "package p2;\npublic class Y {\n    pass");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IModelElement)cuSource, (IModelElement)pkgDest, null, "Y.py", true);
    }

    public void testCopyCUWithCollision() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.py", "package p2;\nclass X:\n    pass");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.copyNegative((IModelElement)cuSource, (IModelElement)pkgDest, null, null, false, 977);
    }

    public void testCopyCUWithInvalidDestination() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.copyNegative((IModelElement)cuSource, (IModelElement)cuSource, null, null, false, 978);
    }

    public void testCopyCUWithNullContainer() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        try {
            cuSource.copy(null, null, null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        CopyMoveResourcesTests.assertTrue((String)"Should not be able to move a cu to a null container", (boolean)false);
    }

    public void testCopyCUWithServerProperties() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        QualifiedName qualifiedName = new QualifiedName("x.y.z", "a property");
        cuSource.getUnderlyingResource().setPersistentProperty(qualifiedName, "some value");
        this.createFolder("/P/src/p2");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.copyPositive((IModelElement)cuSource, (IModelElement)pkgDest, null, null, false);
        ISourceModule cu = pkgDest.getSourceModule("X.py");
        String propertyValue = cu.getUnderlyingResource().getPersistentProperty(qualifiedName);
        CopyMoveResourcesTests.assertEquals((String)"Server property should be copied with cu", (String)"some value", (String)propertyValue);
    }

    public void testCopyScriptFolder() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        IScriptFolder pkgSource = this.getPackage("/P/src/p1");
        IProjectFragment rootDest = this.getProjectFragment("P", "src2");
        this.copyPositive((IModelElement)pkgSource, (IModelElement)rootDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCopyReadOnlyScriptFolder() throws CoreException {
        IFile xFile2;
        IScriptFolder p3Fragment2;
        IScriptFolder p1Fragment2;
        IScriptFolder pkgSource = null;
        IScriptFolder pkg2 = null;
        try {
            this.createFolder("/P/src/p1/p2/p3");
            this.createFile("/P/src/p1/p2/p3/X.py", "class X:\n    pass");
            this.setReadOnly((IResource)this.getFile("/P/src/p1/p2/p3/X.py"), true);
            pkgSource = this.getPackage("/P/src/p1");
            this.setReadOnly(pkgSource.getResource(), true);
            pkg2 = this.getPackage("/P/src/p1/p2/p3");
            this.setReadOnly(pkg2.getResource(), true);
            IProjectFragment rootDest = this.getProjectFragment("P", "src2");
            this.copyPositive((IModelElement)pkg2, (IModelElement)rootDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)this.isReadOnly(this.getPackage("/P/src2/p1").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (!this.isReadOnly(this.getPackage("/P/src2/p1/p2").getResource()) ? 1 : 0) != 0);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)this.isReadOnly(this.getPackage("/P/src2/p1/p2/p3").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (boolean)this.isReadOnly((IResource)this.getFile("/P/src2/p1/p2/p3/X.py")));
        }
        catch (Throwable throwable) {
            IFile xFile2;
            IScriptFolder p3Fragment2;
            IScriptFolder p1Fragment2;
            Object var4_5 = null;
            IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.py");
            if (xSrcFile != null) {
                this.setReadOnly((IResource)xSrcFile, false);
            }
            if (pkg2 != null) {
                this.setReadOnly(pkg2.getResource(), false);
            }
            if (pkgSource != null) {
                this.setReadOnly(pkgSource.getResource(), false);
            }
            if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
                this.setReadOnly(p1Fragment2.getResource(), false);
            }
            if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
                this.setReadOnly(p3Fragment2.getResource(), false);
            }
            if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.py")) != null) {
                this.setReadOnly((IResource)xFile2, false);
            }
            this.deleteFolder("/P/src/p1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.py");
        if (xSrcFile != null) {
            this.setReadOnly((IResource)xSrcFile, false);
        }
        if (pkg2 != null) {
            this.setReadOnly(pkg2.getResource(), false);
        }
        if (pkgSource != null) {
            this.setReadOnly(pkgSource.getResource(), false);
        }
        if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
            this.setReadOnly(p1Fragment2.getResource(), false);
        }
        if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
            this.setReadOnly(p3Fragment2.getResource(), false);
        }
        if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.py")) != null) {
            this.setReadOnly((IResource)xFile2, false);
        }
        this.deleteFolder("/P/src/p1");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopy() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 85->89)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyDestination() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 104->108)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyForce() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 96->100)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyRename() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 87->91)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyRenameForce() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 98->102)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyWithCollision() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 98->102)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testCopyWorkingCopyWithInvalidDestination() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 70->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void testMoveCUForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.py", "package p2;\nclass X:\n    pass");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IModelElement)cuSource, (IModelElement)pkgDest, null, null, true);
    }

    public void testMoveCURename() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IModelElement)cuSource, (IModelElement)pkgDest, null, "Y.py", false);
    }

    public void testMoveCURenameForce() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/Y.py", "package p2;\npublic class Y {\n    pass");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.movePositive((IModelElement)cuSource, (IModelElement)pkgDest, null, "Y.py", true);
    }

    public void testMoveCUWithCollision() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.createFolder("/P/src/p2");
        this.createFile("/P/src/p2/X.py", "package p2;\nclass X:\n    pass");
        IScriptFolder pkgDest = this.getPackage("/P/src/p2");
        this.moveNegative((IModelElement)cuSource, (IModelElement)pkgDest, null, null, false, 977);
    }

    public void testMoveCUWithInvalidDestination() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        this.moveNegative((IModelElement)cuSource, (IModelElement)cuSource, null, null, false, 978);
    }

    public void testMoveCUWithNullContainer() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        ISourceModule cuSource = this.getSourceModule("/P/src/p1/X.py");
        try {
            cuSource.move(null, null, null, false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        CopyMoveResourcesTests.assertTrue((String)"Should not be able to move a cu to a null container", (boolean)false);
    }

    public void testMoveScriptFolder() throws CoreException {
        this.createFolder("/P/src/p1");
        this.createFile("/P/src/p1/X.py", "class X:\n    pass");
        IScriptFolder pkgSource = this.getPackage("/P/src/p1");
        IProjectFragment rootDest = this.getProjectFragment("P", "src2");
        this.movePositive((IModelElement)pkgSource, (IModelElement)rootDest, null, null, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMoveReadOnlyScriptFolder() throws CoreException {
        IFile xFile2;
        IScriptFolder p3Fragment2;
        IScriptFolder p1Fragment2;
        IScriptFolder pkgSource = null;
        IScriptFolder pkg2 = null;
        try {
            this.createFolder("/P/src/p1/p2/p3");
            this.createFile("/P/src/p1/p2/p3/X.py", "class X:\n    pass");
            this.setReadOnly((IResource)this.getFile("/P/src/p1/p2/p3/X.py"), true);
            pkgSource = this.getPackage("/P/src/p1");
            this.setReadOnly(pkgSource.getResource(), true);
            pkg2 = this.getPackage("/P/src/p1/p2/p3");
            this.setReadOnly(pkg2.getResource(), true);
            IProjectFragment rootDest = this.getProjectFragment("P", "src2");
            this.movePositive((IModelElement)pkg2, (IModelElement)rootDest, null, null, false);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)this.isReadOnly(this.getPackage("/P/src2/p1").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (!this.isReadOnly(this.getPackage("/P/src2/p1/p2").getResource()) ? 1 : 0) != 0);
            CopyMoveResourcesTests.assertTrue((String)"Not readOnly", (boolean)this.isReadOnly(this.getPackage("/P/src2/p1/p2/p3").getResource()));
            CopyMoveResourcesTests.assertTrue((String)"Is readOnly", (boolean)this.isReadOnly((IResource)this.getFile("/P/src2/p1/p2/p3/X.py")));
        }
        catch (Throwable throwable) {
            IFile xFile2;
            IScriptFolder p3Fragment2;
            IScriptFolder p1Fragment2;
            Object var4_5 = null;
            IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.py");
            if (xSrcFile != null) {
                this.setReadOnly((IResource)xSrcFile, false);
            }
            if (pkg2 != null) {
                this.setReadOnly(pkg2.getResource(), false);
            }
            if (pkgSource != null) {
                this.setReadOnly(pkgSource.getResource(), false);
            }
            if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
                this.setReadOnly(p1Fragment2.getResource(), false);
            }
            if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
                this.setReadOnly(p3Fragment2.getResource(), false);
            }
            if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.py")) != null) {
                this.setReadOnly((IResource)xFile2, false);
            }
            this.deleteFolder("/P/src/p1");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        IFile xSrcFile = this.getFile("/P/src/p1/p2/p3/X.py");
        if (xSrcFile != null) {
            this.setReadOnly((IResource)xSrcFile, false);
        }
        if (pkg2 != null) {
            this.setReadOnly(pkg2.getResource(), false);
        }
        if (pkgSource != null) {
            this.setReadOnly(pkgSource.getResource(), false);
        }
        if ((p1Fragment2 = this.getPackage("/P/src2/p1")) != null) {
            this.setReadOnly(p1Fragment2.getResource(), false);
        }
        if ((p3Fragment2 = this.getPackage("/P/src2/p1/p2/p3")) != null) {
            this.setReadOnly(p3Fragment2.getResource(), false);
        }
        if ((xFile2 = this.getFile("/P/src2/p1/p2/p3/X.py")) != null) {
            this.setReadOnly((IResource)xFile2, false);
        }
        this.deleteFolder("/P/src/p1");
    }

    /*
     * Exception decompiling
     */
    public void testMoveWorkingCopy() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 87->91)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void testMoveWorkingCopy2() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 108->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

