/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.debug.ui.launchConfigurations.ScriptLaunchConfigurationTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.ui.preferences.FieldValidators;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public abstract class RemoteLaunchConfigurationTab
extends ScriptLaunchConfigurationTab {
    private static int DEFAULT_PORT = 10000;
    private static String DEFAULT_IDEKEY = "idekey";
    protected Text port;
    protected Text ideKey;
    protected Text remoteWorkingDir;

    public RemoteLaunchConfigurationTab(String mode) {
        super(mode);
    }

    public String getName() {
        return DLTKLaunchConfigurationsMessages.remoteTab_title;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    protected void doInitializeForm(ILaunchConfiguration config) {
        this.port.setText(this.getLaunchAttr(config, "dbpg_port", Integer.toString(this.getDefaultPort())));
        this.ideKey.setText(this.getLaunchAttr(config, "dbgp_session_id", this.getDefaultIDEKey()));
        this.remoteWorkingDir.setText(this.getLaunchAttr(config, "remoteWorkingDir", this.getDefaultRemoteWorkingDir()));
    }

    protected int getDefaultPort() {
        return DEFAULT_PORT;
    }

    protected String getDefaultIDEKey() {
        return DEFAULT_IDEKEY;
    }

    protected String getDefaultRemoteWorkingDir() {
        return "";
    }

    protected void doPerformApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("dbpg_port", this.port.getText().trim());
        config.setAttribute("dbgp_session_id", this.ideKey.getText().trim());
        config.setAttribute("remoteWorkingDir", this.remoteWorkingDir.getText().trim());
    }

    protected boolean doCanSave() {
        return this.validatePort() && this.validateIdeKey() && this.validateRemoteWorkingDir();
    }

    protected boolean validatePort() {
        IStatus result = FieldValidators.PORT_VALIDATOR.validate(this.port.getText());
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        return true;
    }

    protected boolean validateIdeKey() {
        String projectName = this.ideKey.getText().trim();
        if (projectName.length() == 0) {
            this.setErrorMessage(DLTKLaunchConfigurationsMessages.remoteError_ideKeyEmpty);
            return false;
        }
        return true;
    }

    protected boolean validateRemoteWorkingDir() {
        return true;
    }

    protected String guessProjectName() {
        String[] guesses = this.getProjectAndScriptNames();
        return guesses == null ? "" : guesses[0];
    }

    protected void doCreateControl(Composite composite) {
        Group group = SWTFactory.createGroup((Composite)composite, (String)DLTKLaunchConfigurationsMessages.remoteTab_connectionProperties, (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)group, (String)DLTKLaunchConfigurationsMessages.remoteTab_connectionPort, (int)1);
        this.port = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        SWTFactory.createLabel((Composite)group, (String)DLTKLaunchConfigurationsMessages.remoteTab_connectionIdeKey, (int)1);
        this.ideKey = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.ideKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        SWTFactory.createHorizontalSpacer((Composite)composite, (int)1);
        group = SWTFactory.createGroup((Composite)composite, (String)DLTKLaunchConfigurationsMessages.remoteTab_remoteWorkingDir, (int)1, (int)1, (int)768);
        this.remoteWorkingDir = SWTFactory.createText((Composite)group, (int)2048, (int)1, (String)"");
        this.remoteWorkingDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private String getLaunchAttr(ILaunchConfiguration config, String key, String defaultValue) {
        String text = null;
        try {
            text = config.getAttribute(key, defaultValue);
        }
        catch (CoreException coreException) {
            text = defaultValue;
        }
        return text;
    }
}

