/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsoleHistory;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ui.IConsoleStyleProvider;
import org.eclipse.dltk.console.ui.IScriptConsoleInput;
import org.eclipse.dltk.console.ui.IScriptConsoleListener;
import org.eclipse.dltk.console.ui.IScriptConsoleSession;
import org.eclipse.dltk.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.console.ui.ScriptConsoleSourceViewerConfiguration;
import org.eclipse.dltk.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleInput;
import org.eclipse.dltk.console.ui.internal.ScriptConsolePage;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleSession;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleViewer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ScriptConsole
extends TextConsole
implements ICommandHandler {
    private ILaunch launch = null;
    private ILaunchesListener2 listener = null;
    protected ScriptConsolePage page;
    private ScriptConsolePartitioner partitioner;
    private IContentAssistProcessor processor;
    private ITextHover hover;
    private IScriptInterpreter interpreter;
    private ScriptConsoleSession session;
    private ListenerList consoleListeners;
    private ScriptConsolePrompt prompt;
    private ScriptConsoleHistory history;
    private IConsoleStyleProvider styleProvider;
    private boolean terminated = false;
    private Color colorBlack = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
    private Color colorBlue = new Color((Device)Display.getCurrent(), new RGB(0, 0, 255));
    private Color colorRed = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
    private ScriptConsoleViewer.ConsoleDocumentListener documentListener;

    protected void appendInvitation(final ScriptConsoleViewer viewer) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                block2: {
                    try {
                        viewer.disableProcessing();
                        ScriptConsole.this.getDocumentListener().appendDelimeter();
                        ScriptConsole.this.getDocumentListener().appendInvitation();
                        viewer.enableProcessing();
                    }
                    catch (BadLocationException e) {
                        if (!DLTKCore.DEBUG) break block2;
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    protected void enableEdit(final ScriptConsoleViewer viewer) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                viewer.setEditable(true);
            }
        });
    }

    private void updateText(final ScriptConsoleViewer viewer, final String text, final boolean clean) {
        Control control = viewer.getControl();
        if (control == null) {
            return;
        }
        control.getDisplay().asyncExec(new Runnable(){

            public void run() {
                block5: {
                    viewer.disableProcessing();
                    IDocument document = ScriptConsole.this.getDocument();
                    try {
                        if (clean) {
                            document.replace(0, document.getLength(), text);
                            ScriptConsole.this.getDocumentListener().appendDelimeter();
                        } else {
                            document.replace(document.getLength(), 0, text);
                            ScriptConsole.this.getDocumentListener().appendDelimeter();
                        }
                        IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
                        if (partitioner instanceof ScriptConsolePartitioner) {
                            ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                            scriptConsolePartitioner.clearRanges();
                            viewer.getTextWidget().redraw();
                        }
                    }
                    catch (BadLocationException e) {
                        if (!DLTKCore.DEBUG) break block5;
                        e.printStackTrace();
                    }
                }
                viewer.enableProcessing();
            }
        });
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public ScriptConsole(String consoleName, String consoleType, ImageDescriptor image) {
        super(consoleName, consoleType, image, true);
        this.consoleListeners = new ListenerList(1);
        this.prompt = new ScriptConsolePrompt("=>", "->");
        this.history = new ScriptConsoleHistory();
        this.session = new ScriptConsoleSession();
        this.addListener(this.session);
        this.partitioner = new ScriptConsolePartitioner();
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
        this.styleProvider = new IConsoleStyleProvider(){

            protected StyleRange[] createStyles(int start, String content, boolean isInput, boolean isError) {
                ArrayList<StyleRange> rangeList = new ArrayList<StyleRange>();
                if (!(ScriptConsole.this.colorBlack.isDisposed() || ScriptConsole.this.colorRed.isDisposed() || ScriptConsole.this.colorBlue.isDisposed())) {
                    StringTokenizer tokenizer = new StringTokenizer(content, " \t\n\r\f@#=|,()[]{}<>'\"", true);
                    int tokenStart = start;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (isInput) {
                            rangeList.add(new StyleRange(tokenStart, token.length(), ScriptConsole.this.colorBlack, null, 1));
                        } else if (isError) {
                            rangeList.add(new StyleRange(tokenStart, token.length(), ScriptConsole.this.colorRed, null, 1));
                        } else {
                            rangeList.add(new StyleRange(tokenStart, token.length(), ScriptConsole.this.colorBlue, null));
                        }
                        tokenStart += token.length();
                    }
                }
                return rangeList.toArray(new StyleRange[rangeList.size()]);
            }

            public StyleRange[] createPromptStyle(ScriptConsolePrompt prompt, int offset) {
                return this.createStyles(offset, prompt.toString(), true, false);
            }

            public StyleRange[] createUserInputStyle(String content, int offset) {
                return this.createStyles(offset, content, true, false);
            }

            public StyleRange[] createInterpreterOutputStyle(String content, int offset) {
                return this.createStyles(offset, content, false, false);
            }
        };
    }

    public ScriptConsole(String consoleName, String consoleType) {
        this(consoleName, consoleType, null);
    }

    public IScriptConsoleSession getSession() {
        return this.session;
    }

    public void addListener(IScriptConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeListener(IScriptConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    protected void setContentAssistProcessor(IContentAssistProcessor processor) {
        this.processor = processor;
    }

    protected void setInterpreter(IScriptInterpreter interpreter) {
        this.interpreter = interpreter;
        interpreter.addInitialListenerOperation((Runnable)new InitialStreamReader(interpreter));
    }

    protected void setStyleProvider(IConsoleStyleProvider provider) {
        this.styleProvider = provider;
    }

    public void setPrompt(ScriptConsolePrompt prompt) {
        this.prompt = prompt;
    }

    public ScriptConsolePrompt getPrompt() {
        return this.prompt;
    }

    public ScriptConsoleHistory getHistory() {
        return this.history;
    }

    protected void setTextHover(ITextHover hover) {
        this.hover = hover;
    }

    public ScriptConsoleViewer.ConsoleDocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new ScriptConsoleViewer.ConsoleDocumentListener(this, this.getPrompt(), this.getHistory());
            this.documentListener.setDocument(this.getDocument());
        }
        return this.documentListener;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        ScriptConsoleSourceViewerConfiguration cfg = new ScriptConsoleSourceViewerConfiguration(this.processor, this.hover);
        this.page = new ScriptConsolePage(this, view, cfg);
        if (this.styleProvider != null) {
            this.page.setStyleProviser(this.styleProvider);
        }
        return this.page;
    }

    public void clearConsole() {
        this.page.clearConsolePage();
    }

    public IScriptConsoleInput getInput() {
        return new ScriptConsoleInput(this.page);
    }

    public String handleCommand(String userInput) throws IOException {
        if (this.interpreter == null && this.interpreter.isValid()) {
            return "";
        }
        Object[] listeners = this.consoleListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IScriptConsoleListener)listeners[i]).userRequest(userInput);
            ++i;
        }
        this.interpreter.exec(userInput);
        String output = this.interpreter.getOutput();
        if (this.interpreter.getState() == 0) {
            this.prompt.setMode(true);
        } else {
            this.prompt.setMode(false);
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            ((IScriptConsoleListener)listeners[i2]).interpreterResponse(output);
            ++i2;
        }
        return output;
    }

    public void terminate() {
        block2: {
            this.terminated = true;
            try {
                this.interpreter.close();
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.partitioner.clearRanges();
        this.colorBlack.dispose();
        this.colorBlue.dispose();
        this.colorRed.dispose();
        this.terminate();
        if (this.listener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.listener);
        }
        super.dispose();
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
        if (this.listener == null) {
            this.listener = new ScriptConsoleLaunchListener();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.listener);
        }
    }

    static /* synthetic */ void access$2(ScriptConsole scriptConsole, ScriptConsoleViewer scriptConsoleViewer, String string, boolean bl) {
        scriptConsole.updateText(scriptConsoleViewer, string, bl);
    }

    private final class InitialStreamReader
    implements Runnable {
        private final IScriptInterpreter interpreter;

        private InitialStreamReader(IScriptInterpreter interpreter) {
            this.interpreter = interpreter;
        }

        public void run() {
            while (ScriptConsole.this.page == null || ScriptConsole.this.page != null && ScriptConsole.this.page.getViewer() == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!DLTKCore.DEBUG) continue;
                    e.printStackTrace();
                }
            }
            ScriptConsoleViewer viewer = (ScriptConsoleViewer)ScriptConsole.this.page.getViewer();
            InputStream stream = this.interpreter.getInitialOutputStream();
            if (stream == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            Thread readerThread = new Thread(new Runnable(this, reader, viewer){
                final /* synthetic */ InitialStreamReader this$1;
                private final /* synthetic */ BufferedReader val$reader;
                private final /* synthetic */ ScriptConsoleViewer val$viewer;
                {
                    this.this$1 = initialStreamReader;
                    this.val$reader = bufferedReader;
                    this.val$viewer = scriptConsoleViewer;
                }

                public void run() {
                    boolean first = true;
                    while (!ScriptConsole.access$0(InitialStreamReader.access$1(this.this$1))) {
                        try {
                            String readLine = this.val$reader.readLine();
                            if (readLine == null) break;
                            ScriptConsole.access$2(InitialStreamReader.access$1(this.this$1), this.val$viewer, readLine, first);
                            first = false;
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break;
                            e.printStackTrace();
                            break;
                        }
                    }
                    InitialStreamReader.access$1(this.this$1).appendInvitation(this.val$viewer);
                    InitialStreamReader.access$1(this.this$1).enableEdit(this.val$viewer);
                }
            });
            readerThread.start();
        }

        static /* synthetic */ ScriptConsole access$1(InitialStreamReader initialStreamReader) {
            return initialStreamReader.ScriptConsole.this;
        }
    }

    private class ScriptConsoleLaunchListener
    implements ILaunchesListener2 {
        private ScriptConsoleLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] launches) {
            if (ScriptConsole.this.terminated) {
                return;
            }
            int i = 0;
            while (i < launches.length) {
                if (launches[i].equals(ScriptConsole.this.launch)) {
                    ScriptConsoleViewer consoleViewer = (ScriptConsoleViewer)ScriptConsole.this.page.getViewer();
                    ScriptConsole.this.page.getControl().getDisplay().asyncExec(new Runnable(this, consoleViewer){
                        final /* synthetic */ ScriptConsoleLaunchListener this$1;
                        private final /* synthetic */ ScriptConsoleViewer val$consoleViewer;
                        {
                            this.this$1 = scriptConsoleLaunchListener;
                            this.val$consoleViewer = scriptConsoleViewer;
                        }

                        public void run() {
                            if (this.val$consoleViewer != null) {
                                this.val$consoleViewer.disableProcessing();
                                ScriptConsoleLaunchListener.access$1(this.this$1).appendInvitation(this.val$consoleViewer);
                                ScriptConsole.access$2(ScriptConsoleLaunchListener.access$1(this.this$1), this.val$consoleViewer, "Process terminated...", false);
                                this.val$consoleViewer.setEditable(false);
                            }
                        }
                    });
                }
                ++i;
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        static /* synthetic */ ScriptConsole access$1(ScriptConsoleLaunchListener scriptConsoleLaunchListener) {
            return scriptConsoleLaunchListener.ScriptConsole.this;
        }
    }
}

