/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.ast.TclAdvancedExecuteExpression;
import org.eclipse.dltk.tcl.core.ast.TclSwitchStatement;

public class TclSwitchCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        TclSwitchStatement switchStatement;
        block12: {
            int patternsStart;
            block13: {
                switchStatement = new TclSwitchStatement(statement.sourceStart(), statement.sourceEnd());
                this.addToParent(parent, (ASTNode)switchStatement);
                patternsStart = -1;
                int i = 1;
                while (i < statement.getCount()) {
                    Expression at = statement.getAt(i);
                    if (at instanceof SimpleReference) {
                        String value = ((SimpleReference)at).getName();
                        if (!("-exact".equals(value) || "-regexp".equals(value) || "-glob".equals(value) || "--".equals(value))) {
                            patternsStart = i + 1;
                            switchStatement.setString((ASTNode)at);
                            break;
                        }
                    } else {
                        if (at instanceof StringLiteral) {
                            patternsStart = i + 1;
                            switchStatement.setString((ASTNode)at);
                            break;
                        }
                        if (at instanceof TclAdvancedExecuteExpression) {
                            patternsStart = i + 1;
                            switchStatement.setString((ASTNode)at);
                            break;
                        }
                    }
                    ++i;
                }
                if (patternsStart == -1 || patternsStart >= statement.getCount()) break block12;
                Expression at = statement.getAt(patternsStart);
                if (!(at instanceof TclBlockExpression)) break block13;
                List list = ((TclBlockExpression)at).parseBlockSimple(false);
                Block bll = new Block(at.sourceStart(), at.sourceEnd());
                switchStatement.acceptBlock(bll);
                if (list == null) break block12;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ASTNode st = (ASTNode)iterator.next();
                    if (st instanceof TclBlockExpression) {
                        this.parserBlockAddTo(parser, switchStatement, (TclBlockExpression)st);
                    }
                    if (!(st instanceof TclStatement)) continue;
                    TclStatement stt = (TclStatement)st;
                    int i2 = 0;
                    while (i2 < stt.getCount()) {
                        Expression sttt = stt.getAt(i2);
                        if (sttt instanceof TclBlockExpression) {
                            this.parserBlockAddTo(parser, switchStatement, (TclBlockExpression)sttt);
                        }
                        ++i2;
                    }
                }
                break block12;
            }
            int index = 0;
            int i = patternsStart;
            while (i < statement.getCount()) {
                Expression st = statement.getAt(patternsStart);
                if (st instanceof TclBlockExpression) {
                    this.parserBlockAddTo(parser, switchStatement, (TclBlockExpression)st);
                }
                ++index;
                ++i;
            }
        }
        return switchStatement;
    }

    private void parserBlockAddTo(ITclParser parser, TclSwitchStatement switchStatement, TclBlockExpression st) {
        Block block = new Block(st.sourceStart(), st.sourceEnd());
        String content = parser.substring(st.sourceStart(), st.sourceEnd());
        if (content.startsWith("{") && content.endsWith("}")) {
            content = parser.substring(st.sourceStart() + 1, st.sourceEnd() - 1);
        }
        switchStatement.addChild(block);
        parser.parse(content, st.sourceStart() + 1 - parser.getStartPos(), (ASTNode)block);
    }
}

