/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.internal.core.packages.DLTKTclHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PackagesManager {
    private static final String DEPENDENCY_TAG = "dependency";
    private static final String INTERPRETER_TAG = "interpreter";
    private static final String VALUE_ATTR = "value";
    private static final String PACKAGES_FILE = "packages.txt";
    private static final String PACKAGES_TAG = "packages";
    private static final String PACKAGE_TAG = "package";
    private static final String INTERPRETER_ATTR = "interpreter";
    private static final String NAME_ATTR = "name";
    private static final String PATH_TAG = "path";
    private static PackagesManager manager;
    private Map packages = new HashMap();
    private Map interpreterToPackages = new HashMap();

    public static PackagesManager getInstance() {
        if (manager == null) {
            manager = new PackagesManager();
        }
        return manager;
    }

    private PackagesManager() {
        this.initialize();
    }

    private void initialize() {
        block9: {
            IPath packagesPath = TclPlugin.getDefault().getStateLocation().append(PACKAGES_FILE);
            File packagesFile = packagesPath.toFile();
            if (packagesFile.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(new BufferedInputStream(new FileInputStream(packagesFile), 2048));
                    this.populate(document.getDocumentElement());
                }
                catch (ParserConfigurationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (SAXException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
        }
    }

    private void save() {
        block8: {
            IPath packagesPath = TclPlugin.getDefault().getStateLocation().append(PACKAGES_FILE);
            File packagesFile = packagesPath.toFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                this.save(document);
                FileOutputStream fos = new FileOutputStream(packagesFile, false);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 2048);
                TransformerFactory serFactory = TransformerFactory.newInstance();
                Transformer transformer = serFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult outputTarget = new StreamResult(bos);
                transformer.transform(source, outputTarget);
                bos.close();
                fos.close();
            }
            catch (ParserConfigurationException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (TransformerException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
    }

    private synchronized void save(Document doc) {
        Element packagesElement = doc.createElement(PACKAGES_TAG);
        doc.appendChild(packagesElement);
        Iterator iterator = this.packages.keySet().iterator();
        while (iterator.hasNext()) {
            PackageKey key = (PackageKey)iterator.next();
            Element packageElement = doc.createElement(PACKAGE_TAG);
            packageElement.setAttribute(NAME_ATTR, key.getPackageName());
            packageElement.setAttribute("interpreter", key.getInterpreterPath());
            PackageInformation info = (PackageInformation)this.packages.get(key);
            Set paths = info.getPaths();
            Iterator iterator2 = paths.iterator();
            while (iterator2.hasNext()) {
                IPath path = (IPath)iterator2.next();
                Element pathElement = doc.createElement(PATH_TAG);
                pathElement.setAttribute(VALUE_ATTR, path.toOSString());
                packageElement.appendChild(pathElement);
            }
            Set deps = info.getDependencies();
            Iterator iterator22 = deps.iterator();
            while (iterator22.hasNext()) {
                String pkgName = (String)iterator22.next();
                Element pkgElement = doc.createElement(DEPENDENCY_TAG);
                pkgElement.setAttribute(NAME_ATTR, pkgName);
                packageElement.appendChild(pkgElement);
            }
            packagesElement.appendChild(packageElement);
        }
        iterator = this.interpreterToPackages.keySet().iterator();
        while (iterator.hasNext()) {
            String interpreter = (String)iterator.next();
            Element interpreterElement = doc.createElement("interpreter");
            interpreterElement.setAttribute(NAME_ATTR, interpreter);
            Set pkgs = (Set)this.interpreterToPackages.get(interpreter);
            Iterator iterator2 = pkgs.iterator();
            while (iterator2.hasNext()) {
                String pkgName = (String)iterator2.next();
                Element pathElement = doc.createElement(PACKAGE_TAG);
                pathElement.setAttribute(VALUE_ATTR, pkgName);
                interpreterElement.appendChild(pathElement);
            }
            packagesElement.appendChild(interpreterElement);
        }
    }

    private synchronized void populate(Element documentElement) {
        NodeList childNodes = documentElement.getChildNodes();
        int length = childNodes.getLength();
        int i = 0;
        while (i < length) {
            Node child = childNodes.item(i);
            if (child.getNodeType() == 1) {
                Element e;
                if (child.getNodeName().equalsIgnoreCase(PACKAGE_TAG)) {
                    e = (Element)child;
                    String packageName = e.getAttribute(NAME_ATTR);
                    String interpreter = e.getAttribute("interpreter");
                    PackageInformation packageInfo = new PackageInformation();
                    NodeList childrens = e.getChildNodes();
                    int j = 0;
                    while (j < childrens.getLength()) {
                        Node path = childrens.item(j);
                        if (path.getNodeType() == 1) {
                            if (path.getNodeName().equalsIgnoreCase(PATH_TAG)) {
                                String pathValue = ((Element)path).getAttribute(VALUE_ATTR);
                                packageInfo.getPaths().add(new Path(pathValue));
                            } else if (path.getNodeName().equalsIgnoreCase(DEPENDENCY_TAG)) {
                                String pkgName = ((Element)path).getAttribute(NAME_ATTR);
                                packageInfo.getDependencies().add(pkgName);
                            }
                        }
                        ++j;
                    }
                    this.packages.put(this.makeKey(packageName, interpreter), packageInfo);
                } else if (child.getNodeName().equalsIgnoreCase("interpreter")) {
                    e = (Element)child;
                    String interpreter = e.getAttribute(NAME_ATTR);
                    NodeList paths = e.getChildNodes();
                    HashSet<String> packagesSet = new HashSet<String>();
                    int j = 0;
                    while (j < paths.getLength()) {
                        Node packageNode = paths.item(j);
                        if (packageNode.getNodeType() == 1 && packageNode.getNodeName().equalsIgnoreCase(PACKAGE_TAG)) {
                            String packageNameValue = ((Element)packageNode).getAttribute(VALUE_ATTR);
                            packagesSet.add(packageNameValue);
                        }
                        ++j;
                    }
                    this.interpreterToPackages.put(interpreter, packagesSet);
                }
            }
            ++i;
        }
    }

    private PackageKey makeKey(String packageName, String interpreter) {
        PackageKey key = new PackageKey();
        key.setPackageName(packageName);
        key.setInterpreterPath(interpreter);
        return key;
    }

    public synchronized IPath[] getPathsForPackage(IInterpreterInstall install, String packageName) {
        PackageKey key = this.makeKey(packageName, this.getInterpreterKey(install));
        if (this.packages.containsKey(key)) {
            PackageInformation info = (PackageInformation)this.packages.get(key);
            Set els = info.getPaths();
            return els.toArray(new IPath[els.size()]);
        }
        DLTKTclHelper.TclPackage[] srcs = DLTKTclHelper.getSrcs(install.getExecEnvironment(), install.getInstallLocation(), install.getEnvironmentVariables(), packageName);
        PackageInformation resultInfo = null;
        int i = 0;
        while (i < srcs.length) {
            Set paths2 = srcs[i].getPaths();
            PackageKey okey = this.makeKey(srcs[i].getName(), this.getInterpreterKey(install));
            PackageInformation info = this.packages.containsKey(okey) ? (PackageInformation)this.packages.get(okey) : new PackageInformation();
            info.getPaths().addAll(paths2);
            info.getDependencies().addAll(srcs[i].getDependencies());
            this.packages.put(okey, info);
            if (okey.equals(key)) {
                resultInfo = info;
            }
            ++i;
        }
        if (resultInfo == null) {
            this.packages.put(key, new PackageInformation());
            return new IPath[0];
        }
        HashSet resultPaths = new HashSet();
        resultPaths.addAll(resultInfo.getPaths());
        this.save();
        return resultPaths.toArray(new IPath[resultPaths.size()]);
    }

    public synchronized Map getDependencies(String pkgName, IInterpreterInstall install) {
        HashSet checkedPackages = new HashSet();
        HashMap packagesSet = new HashMap();
        PackageKey key = this.makeKey(pkgName, install);
        PackageInformation info = (PackageInformation)this.packages.get(key);
        if (info != null) {
            this.traverseDependencies(packagesSet, checkedPackages, info, install);
        }
        return packagesSet;
    }

    private PackageKey makeKey(String pkgName, IInterpreterInstall install) {
        return this.makeKey(pkgName, this.getInterpreterKey(install));
    }

    private synchronized void traverseDependencies(Map packagesSet, Set checkedPackages, PackageInformation resultInfo, IInterpreterInstall install) {
        Set dependencies = resultInfo.getDependencies();
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            String pkgName = (String)iterator.next();
            if (checkedPackages.contains(pkgName)) continue;
            checkedPackages.add(pkgName);
            PackageKey pkgKey = this.makeKey(pkgName, this.getInterpreterKey(install));
            if (!this.packages.containsKey(pkgKey)) continue;
            PackageInformation depInfo = (PackageInformation)this.packages.get(pkgKey);
            packagesSet.put(pkgName, depInfo);
            this.traverseDependencies(packagesSet, checkedPackages, depInfo, install);
        }
    }

    public synchronized Set getPackageNames(IInterpreterInstall install) {
        String key = this.getInterpreterKey(install);
        if (this.interpreterToPackages.containsKey(key)) {
            Set set = (Set)this.interpreterToPackages.get(key);
            return set;
        }
        Set packs = DLTKTclHelper.getPackages(install);
        this.interpreterToPackages.put(key, packs);
        this.save();
        return packs;
    }

    private String getInterpreterKey(IInterpreterInstall install) {
        return String.valueOf(install.getInstallLocation().toOSString()) + ":" + install.getEnvironment().getId();
    }

    public synchronized Set getInternalPackageNames(IInterpreterInstall install, IScriptProject project) {
        String key = "internal|||" + project.getElementName() + "|||" + this.getInterpreterKey(install);
        if (this.interpreterToPackages.containsKey(key)) {
            Set set = (Set)this.interpreterToPackages.get(key);
            return set;
        }
        return new HashSet();
    }

    public synchronized void setInternalPackageNames(IInterpreterInstall install, Set names) {
        String key = "internal|||" + this.getInterpreterKey(install);
        HashSet values = new HashSet();
        values.addAll(names);
        this.interpreterToPackages.put(key, values);
        this.save();
    }

    public synchronized IPath[] getPathsForPackages(IInterpreterInstall install, Set packagesInBuild) {
        StringBuffer buf = new StringBuffer();
        String[] pkgs = packagesInBuild.toArray(new String[packagesInBuild.size()]);
        int i = 0;
        while (i < pkgs.length) {
            buf.append(pkgs[i]).append(" ");
            ++i;
        }
        PackageKey key = this.makeKey(buf.toString(), this.getInterpreterKey(install));
        if (this.packages.containsKey(key)) {
            PackageInformation info = (PackageInformation)this.packages.get(key);
            Set paths = info.getPaths();
            return paths.toArray(new IPath[paths.size()]);
        }
        DLTKTclHelper.TclPackage[] srcs = DLTKTclHelper.getSrcs(install.getExecEnvironment(), install.getInstallLocation(), install.getEnvironmentVariables(), buf.toString());
        HashSet result = new HashSet();
        if (srcs == null) {
            return new IPath[0];
        }
        int i2 = 0;
        while (i2 < srcs.length) {
            Set paths2 = srcs[i2].getPaths();
            PackageKey okey = this.makeKey(srcs[i2].getName(), this.getInterpreterKey(install));
            PackageInformation info = null;
            info = this.packages.containsKey(okey) ? (PackageInformation)this.packages.get(okey) : new PackageInformation();
            result.addAll(paths2);
            info.getPaths().addAll(paths2);
            info.getDependencies().addAll(srcs[i2].getDependencies());
            this.packages.put(okey, info);
            ++i2;
        }
        PackageInformation info = new PackageInformation();
        info.getPaths().addAll(result);
        this.packages.put(key, info);
        int i3 = 0;
        while (i3 < pkgs.length) {
            PackageKey lkey = this.makeKey(pkgs[i3], this.getInterpreterKey(install));
            if (!this.packages.containsKey(lkey)) {
                this.packages.put(lkey, new PackageInformation());
            }
            ++i3;
        }
        this.save();
        return result.toArray(new IPath[result.size()]);
    }

    public IPath[] getAllPaths(String pkgName, IInterpreterInstall install) {
        HashSet<IPath> result = new HashSet<IPath>();
        IPath[] paths = this.getPathsForPackage(install, pkgName);
        result.addAll(Arrays.asList(paths));
        Map dependencies = this.getDependencies(pkgName, install);
        Iterator iterator = dependencies.keySet().iterator();
        while (iterator.hasNext()) {
            String packageName = (String)iterator.next();
            PackageInformation info = (PackageInformation)dependencies.get(packageName);
            result.addAll(info.getPaths());
        }
        return result.toArray(new IPath[result.size()]);
    }

    public synchronized void removeInterprterInfo(IInterpreterInstall install) {
        String interpreterPath = this.getInterpreterKey(install);
        this.interpreterToPackages.remove(interpreterPath);
        Iterator iterator = this.packages.keySet().iterator();
        while (iterator.hasNext()) {
            PackageKey key = (PackageKey)iterator.next();
            String path = key.getInterpreterPath();
            if (!path.equals(interpreterPath)) continue;
            iterator.remove();
        }
        this.save();
    }

    public synchronized void clearCache() {
        this.interpreterToPackages.clear();
        this.packages.clear();
        this.save();
    }

    public IPath[] getPathsForPackageWithDeps(IInterpreterInstall install, String name) {
        HashSet<IPath> result = new HashSet<IPath>();
        IPath[] paths = this.getPathsForPackage(install, name);
        result.addAll(Arrays.asList(paths));
        Map dependencies = manager.getDependencies(name, install);
        Iterator iterator = dependencies.keySet().iterator();
        while (iterator.hasNext()) {
            String pkgName = (String)iterator.next();
            result.addAll(Arrays.asList(this.getPathsForPackage(install, pkgName)));
        }
        return result.toArray(new IPath[result.size()]);
    }

    public IPath[] getPathsForPackagesWithDeps(IInterpreterInstall install, Set packagesSet) {
        HashSet<IPath> result = new HashSet<IPath>();
        IPath[] paths = this.getPathsForPackages(install, packagesSet);
        result.addAll(Arrays.asList(paths));
        Iterator jiterator = packagesSet.iterator();
        while (jiterator.hasNext()) {
            String name = (String)jiterator.next();
            Map dependencies = manager.getDependencies(name, install);
            Iterator iterator = dependencies.keySet().iterator();
            while (iterator.hasNext()) {
                String pkgName = (String)iterator.next();
                result.addAll(Arrays.asList(this.getPathsForPackage(install, pkgName)));
            }
        }
        return result.toArray(new IPath[result.size()]);
    }

    public static class PackageInformation {
        private Set paths = new HashSet();
        private Set dependencies = new HashSet();

        public Set getPaths() {
            return this.paths;
        }

        public void setPaths(Set paths) {
            this.paths = paths;
        }

        public Set getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Set dependencies) {
            this.dependencies = dependencies;
        }
    }

    private static class PackageKey {
        private String packageName;
        private String interpreterPath;

        private PackageKey() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.interpreterPath == null ? 0 : this.interpreterPath.hashCode());
            result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageKey other = (PackageKey)obj;
            if (this.interpreterPath == null ? other.interpreterPath != null : !this.interpreterPath.equals(other.interpreterPath)) {
                return false;
            }
            return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getInterpreterPath() {
            return this.interpreterPath;
        }

        public void setInterpreterPath(String interpreterPath) {
            this.interpreterPath = interpreterPath;
        }
    }
}

