/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.ast.IfStatement;
import org.eclipse.dltk.tcl.core.ast.TclCatchStatement;
import org.eclipse.dltk.tcl.core.ast.TclSwitchStatement;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.tcl.ui.text.TclPartitions;
import org.eclipse.dltk.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class TclFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private List fBlockExcludeList = new ArrayList();
    private int fBlockFolding = 0;
    private List fBlockIncludeList = new ArrayList();
    private boolean fInitCollapseBlocks = true;
    private boolean fInitCollapseComments = true;
    private boolean fInitCollapseNamespaces = true;

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        ISourceParser pp = null;
        pp = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
        ModuleDeclaration md = pp.parse(null, code.toCharArray(), null);
        List statements = md.getStatements();
        if (statements == null) {
            return new AbstractASTFoldingStructureProvider.CodeBlock[0];
        }
        ArrayList result = new ArrayList();
        this.traverse(result, statements, offset, code);
        return result.toArray(new AbstractASTFoldingStructureProvider.CodeBlock[result.size()]);
    }

    private void checkStatement(String code, int offset, List result, Statement sst) {
        if (sst instanceof TclStatement) {
            TclStatement statement = (TclStatement)sst;
            result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)this, (ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
            Iterator si = statement.getExpressions().iterator();
            while (si.hasNext()) {
                Expression ex = (Expression)si.next();
                if (!(ex instanceof TclBlockExpression)) continue;
                TclBlockExpression be = (TclBlockExpression)ex;
                try {
                    String newContents = code.substring(be.sourceStart() + 1, be.sourceEnd() - 1);
                    AbstractASTFoldingStructureProvider.CodeBlock[] cb = this.getCodeBlocks(newContents, offset + be.sourceStart() + 1);
                    int j = 0;
                    while (j < cb.length) {
                        result.add(cb[j]);
                        ++j;
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
        }
    }

    private void traverse(List result, List statements, int offset, String code) {
        Iterator iterator = statements.iterator();
        while (iterator.hasNext()) {
            TypeDeclaration statement;
            ASTNode node = (ASTNode)iterator.next();
            if (node instanceof TclStatement) {
                this.checkStatement(code, offset, result, (Statement)node);
                continue;
            }
            if (node instanceof TypeDeclaration) {
                statement = (TypeDeclaration)node;
                result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)this, (ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
                this.traverse(result, statement.getStatements(), offset, code);
                continue;
            }
            if (node instanceof MethodDeclaration) {
                statement = (MethodDeclaration)node;
                result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)this, (ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
                this.traverse(result, statement.getStatements(), offset, code);
                continue;
            }
            if (node instanceof IfStatement) {
                statement = (IfStatement)node;
                result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)this, (ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
                this.traverse(result, statement.getChilds(), offset, code);
                continue;
            }
            if (!(node instanceof TclCatchStatement)) continue;
            statement = (TclCatchStatement)node;
            result.add(new AbstractASTFoldingStructureProvider.CodeBlock((AbstractASTFoldingStructureProvider)this, (ASTNode)statement, (IRegion)new Region(offset + statement.sourceStart(), statement.sourceEnd() - statement.sourceStart())));
            this.traverse(result, statement.getStatements(), offset, code);
        }
    }

    protected String getCommentPartition() {
        return "__tcl_comment";
    }

    protected ILog getLog() {
        return TclUI.getDefault().getLog();
    }

    protected String getPartition() {
        return "__tcl_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new TclPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return TclPartitions.TCL_PARTITION_TYPES;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected void initializePreferences(IPreferenceStore store) {
        super.initializePreferences(store);
        this.fBlockFolding = store.getInt("editor_folding_blocks");
        String t = store.getString("editor_folding_exclude_list");
        String[] items = t.split(",");
        this.fBlockExcludeList.clear();
        int i = 0;
        while (i < items.length) {
            if (items[i].trim().length() > 0) {
                this.fBlockExcludeList.add(items[i]);
            }
            ++i;
        }
        t = store.getString("editor_folding_include_list");
        items = t.split(",");
        this.fBlockIncludeList.clear();
        i = 0;
        while (i < items.length) {
            if (items[i].trim().length() > 0) {
                this.fBlockIncludeList.add(items[i]);
            }
            ++i;
        }
        this.fFoldNewLines = store.getBoolean("editor_folding_comments_lines");
        this.fInitCollapseBlocks = store.getBoolean("editor_folding_init_blocks");
        this.fInitCollapseComments = store.getBoolean("editor_folding_init_comments");
        this.fInitCollapseNamespaces = store.getBoolean("editor_folding_init_namespaces");
    }

    protected boolean initiallyCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (s instanceof TclStatement) {
            TclStatement statement = (TclStatement)s;
            if (!(statement.getAt(0) instanceof SimpleReference)) {
                return false;
            }
            String name = null;
            name = ((SimpleReference)statement.getAt(0)).getName();
            if (name.equals("namespace")) {
                return ctx.allowCollapsing() && this.fInitCollapseNamespaces;
            }
            return ctx.allowCollapsing() && this.fInitCollapseBlocks;
        }
        return false;
    }

    protected boolean initiallyCollapseComments(AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return ctx.allowCollapsing() && this.fInitCollapseComments;
    }

    protected boolean canFold(String name) {
        switch (this.fBlockFolding) {
            case 0: {
                return name.equals("proc") || name.equals("namespace");
            }
            case 1: {
                return this.fBlockIncludeList.contains(name);
            }
            case 2: {
                return !this.fBlockExcludeList.contains(name);
            }
        }
        return false;
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        if (s instanceof TypeDeclaration) {
            return this.canFold("namespace");
        }
        if (s instanceof MethodDeclaration) {
            return this.canFold("proc");
        }
        if (s instanceof IfStatement) {
            return this.canFold("if");
        }
        if (s instanceof TclSwitchStatement) {
            return this.canFold("if");
        }
        if (s instanceof TclCatchStatement) {
            return this.canFold("catch");
        }
        if (s instanceof TclStatement) {
            TclStatement statement = (TclStatement)s;
            if (!(statement.getAt(0) instanceof SimpleReference)) {
                return false;
            }
            String name = null;
            name = ((SimpleReference)statement.getAt(0)).getName();
            return this.canFold(name);
        }
        return false;
    }
}

