/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.dltk.core.SimpleClassDLTKExtensionManager;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.PositionUpdater;
import org.eclipse.dltk.internal.ui.editor.semantic.highlighting.SemanticHighlighting;
import org.eclipse.dltk.tcl.internal.ui.TclSemanticPositionUpdater;
import org.eclipse.dltk.tcl.internal.ui.text.TclPartitionScanner;
import org.eclipse.dltk.tcl.internal.ui.text.TclSourceViewerConfiguration;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.texteditor.ITextEditor;

public class TclTextTools
extends ScriptTextTools {
    private IPartitionTokenScanner fPartitionScanner;
    private SimpleClassDLTKExtensionManager extensions = new SimpleClassDLTKExtensionManager("org.eclipse.dltk.tcl.ui.tclSemanticHighlighting");
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__tcl_string", "__tcl_comment"};

    public TclTextTools(boolean autoDisposeOnDisplayDispose) {
        super("__tcl_partitioning", LEGAL_CONTENT_TYPES, autoDisposeOnDisplayDispose);
        this.fPartitionScanner = new TclPartitionScanner();
    }

    public ScriptSourceViewerConfiguration createSourceViewerConfiguraton(IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        return new TclSourceViewerConfiguration(this.getColorManager(), preferenceStore, editor, partitioning);
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    private ISemanticHighlightingExtension[] getExtensions() {
        Object[] objects = this.extensions.getObjects();
        ISemanticHighlightingExtension[] exts = new ISemanticHighlightingExtension[objects.length];
        int i = 0;
        while (i < objects.length) {
            exts[i] = (ISemanticHighlightingExtension)objects[i];
            ++i;
        }
        return exts;
    }

    public SemanticHighlighting[] getSemanticHighlightings() {
        ArrayList<SemanticHighlighting> highlightings = new ArrayList<SemanticHighlighting>();
        ISemanticHighlightingExtension[] exts = this.getExtensions();
        int i = 0;
        while (i < exts.length) {
            SemanticHighlighting[] hl = exts[i].getHighlightings();
            if (hl != null) {
                highlightings.addAll(Arrays.asList(hl));
            }
            ++i;
        }
        return new SemanticHighlighting[]{new SH("DLTK_single_line_comment", null)};
    }

    public PositionUpdater getSemanticPositionUpdater() {
        return new TclSemanticPositionUpdater(this.getExtensions());
    }

    public static final class SH
    extends SemanticHighlighting {
        private String preferenceKey;
        private String bgColor;

        public String getBackgroundPreferenceKey() {
            return this.bgColor;
        }

        public SH(String editorXmlTagNameColor, String bgColor) {
            this.preferenceKey = editorXmlTagNameColor;
            this.bgColor = bgColor;
        }

        public String getPreferenceKey() {
            return this.preferenceKey;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.preferenceKey == null ? 0 : this.preferenceKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SH other = (SH)((Object)obj);
            return !(this.preferenceKey == null ? other.preferenceKey != null : !this.preferenceKey.equals(other.preferenceKey));
        }
    }
}

