/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.tcl.internal.tclchecker.TclChecker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerMarker;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;
import org.eclipse.dltk.validators.core.AbstractValidator;
import org.eclipse.dltk.validators.core.IValidatorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TclCheckerImpl
extends AbstractValidator {
    boolean initialized = false;

    protected TclCheckerImpl(String id, IValidatorType type) {
        super(id, null, type);
    }

    protected TclCheckerImpl(String id, String name, IValidatorType type) {
        super(id, name, type);
    }

    protected TclCheckerImpl(String id, Element element, IValidatorType type) {
        super(id, null, type);
        this.loadFrom(element);
    }

    protected void loadFrom(Element element) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        super.loadFrom(element);
    }

    public void storeTo(Document doc, Element element) {
        super.storeTo(doc, element);
    }

    public IStatus validate(IResource[] resource, OutputStream console, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    public IStatus validate(ISourceModule[] module, OutputStream console, IProgressMonitor monitor) {
        ArrayList<ISourceModule> els = new ArrayList<ISourceModule>();
        int i = 0;
        while (i < module.length) {
            IResource res = module[i].getResource();
            if (res != null) {
                els.add(module[i]);
                this.clean(res);
            }
            ++i;
        }
        if (els.size() == 0) {
            return Status.OK_STATUS;
        }
        TclChecker checker = new TclChecker(TclCheckerPlugin.getDefault().getPreferenceStore());
        IScriptProject project = module[0].getScriptProject();
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)project);
        checker.check(els, monitor, console, environment);
        return Status.OK_STATUS;
    }

    public boolean isValidatorValid(IEnvironment environment) {
        TclChecker checker = new TclChecker(TclCheckerPlugin.getDefault().getPreferenceStore());
        return checker.canCheck(environment);
    }

    public void clean(ISourceModule[] module) {
        int i = 0;
        while (i < module.length) {
            this.clean(module[i].getResource());
            ++i;
        }
    }

    public void clean(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null) {
                this.clean(resources[i]);
            }
            ++i;
        }
    }

    public void clean(IResource resource) {
        block2: {
            try {
                TclCheckerMarker.clearMarkers(resource);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public void loadInfo(Element element) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.setActive(new Boolean(element.getAttribute("active")));
    }
}

