/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser;

import java.io.CharArrayReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FakeModuleDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.problem.AbstractProblemReporter;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemReporterProxy;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.ast.RubyModuleDeclaration;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.parsers.jruby.DLTKRubyParser;
import org.eclipse.dltk.ruby.internal.parsers.jruby.RubyASTBuildVisitor;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.parser.RubyParserResult;

public class JRubySourceParser
extends AbstractSourceParser {
    private static boolean silentState = true;
    private static final boolean TRACE_AST_JRUBY = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/traceAST/jruby"));
    private static final boolean TRACE_AST_DLTK = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/traceAST/dltk"));
    private static final Pattern DOT_FIXER = Pattern.compile("\\.(?=[\\s,\\)\\]\\}]|$)");
    private static final Pattern DOLLAR_FIXER = Pattern.compile("\\$(?=[\\s,\\)\\]\\}]|$)");
    private static final Pattern AT_FIXER = Pattern.compile("@(?=[\\s,\\)\\]\\}]|$)");
    private static final Pattern COLON_FIXER1 = Pattern.compile("::(?=[\\s,\\)\\]\\}]|$)");
    private static final Pattern COLON_FIXER2 = Pattern.compile("(?:=>.*,[\\s]*)(:)(?=[\\s]*(?=[,}\\)]))", 8);
    private static final Pattern COLON_FIXER3 = Pattern.compile(":(?=[\\s]*(?=[,}\\)]))", 8);
    private static final Pattern COLON_FIXER_UNSAFE1 = Pattern.compile("(?:=>.*,[\\s]*)(:)(?=[\\s]*$)", 8);
    private static final Pattern COLON_FIXER_UNSAFE2 = Pattern.compile(":(?=[\\s]*$)", 8);
    private static final Pattern INST_BRACK_FIXER = Pattern.compile("@(])");
    private static final Pattern GLOB_BRACK_FIXER = Pattern.compile("\\$(])");
    private static final Pattern COMMA_FIXER1 = Pattern.compile("(?:=>.*)(,)(?=[\\s)]*do)", 8);
    private static final Pattern COMMA_FIXER2 = Pattern.compile(",(?=[\\s)]*do)", 8);
    private static final Pattern COMMA_FIXER3 = Pattern.compile("(?:=>.*,[^=>\r\n]*)([\\:a-zA-Z0-9_!?])(?=[\\s)]*do)", 8);
    private static final Pattern COMMA_FIXER4 = Pattern.compile("(?:=>.*)(,)(?=[\\s]*[)][\\s]*$)", 8);
    private static final Pattern COMMA_FIXER5 = Pattern.compile(",(?=[\\s]*[)][\\s]*$)", 8);
    private static final Pattern COMMA_FIXER6 = Pattern.compile("(?:=>.*,[^=>\r\n]*)([\\:a-zA-Z0-9_!?])(?=[\\s]*[)][\\s]*$)", 8);
    private static final Pattern COMMA_FIXER_UNSAFE1 = Pattern.compile("(?:=>.*)(,)(?=[\\s)]*$)", 8);
    private static final Pattern COMMA_FIXER_UNSAFE2 = Pattern.compile(",(?=[\\s)]*$)", 8);
    private static final Pattern COMMA_FIXER_UNSAFE3 = Pattern.compile("(?:=>.*,[^=>\r\n]*)([\\:a-zA-Z0-9_!?])(?=[\\s)]*$)", 8);
    private static final Pattern HASH_FIXER1 = Pattern.compile("=>(?=[\\s)]*do)", 8);
    private static final Pattern HASH_FIXER2 = Pattern.compile("=>(?=[\\s]*[,}\\)])", 8);
    private static final Pattern HASH_FIXER_UNSAFE1 = Pattern.compile("=>(?=[\\s)]*$)", 8);
    private static final Pattern HASH_FIXER_UNSAFE2 = Pattern.compile("^(?:\\s*)(\\s)(?:[a-zA-Z0-9_\"':]+[\\s]*=>.*$)", 8);
    private IProblemReporter problemReporter = null;
    private static final String missingName = "_missing_method_name_";
    private static final String missingName2 = "NoConstant___________";
    private static final String missingName3 = "_missing_param_name__";
    private static final String missingName4 = "_m_key_ => _m_value__";
    private static final int magicLength = "_missing_method_name_".length();
    private final List fixPositions = new ArrayList();
    private final boolean[] errorState = new boolean[1];
    private RubyParserResult parserResult;

    public static boolean isSilentState() {
        return silentState;
    }

    public static void setSilentState(boolean s) {
        silentState = s;
    }

    private String fixBrokenThings(Pattern pattern, String content, String replacement, int delta) {
        Matcher matcher = pattern.matcher(content);
        StringBuffer result = new StringBuffer();
        int regionStart = 0;
        while (matcher.find(regionStart)) {
            int offset = matcher.start(matcher.groupCount());
            if (offset > regionStart) {
                result.append((Object)content.subSequence(regionStart, offset));
            }
            this.fixPositions.add(new Integer(result.length()));
            result.append(replacement);
            regionStart = offset + delta;
        }
        if (regionStart < content.length() - 1) {
            result.append((Object)content.subSequence(regionStart, content.length()));
        }
        if (regionStart == 0) {
            return content;
        }
        return result.toString();
    }

    private String fixBrokenDots(String content) {
        return this.fixBrokenThings(DOT_FIXER, content, "._missing_method_name_", 1);
    }

    private String fixBrokenColons(String content) {
        String content2 = this.fixBrokenThings(COLON_FIXER1, content, "::NoConstant___________", 2);
        content2 = this.fixBrokenThings(COLON_FIXER2, content2, ":_m_key_ => _m_value__", 1);
        return this.fixBrokenThings(COLON_FIXER3, content2, ":NoConstant___________", 1);
    }

    private String fixBrokenColonsUnsafe(String content) {
        String content2 = this.fixBrokenThings(COLON_FIXER_UNSAFE1, content, ":_m_key_ => _m_value__", 1);
        return this.fixBrokenThings(COLON_FIXER_UNSAFE2, content2, ":NoConstant___________", 1);
    }

    private String fixBrokenDollars(String content) {
        return this.fixBrokenThings(DOLLAR_FIXER, content, "$_missing_method_name_", 1);
    }

    private String fixBrokenAts(String content) {
        return this.fixBrokenThings(AT_FIXER, content, "@_missing_method_name_", 1);
    }

    private String fixBrokenInstbracks(String content) {
        return this.fixBrokenThings(INST_BRACK_FIXER, content, "@_missing_method_name_", 1);
    }

    private String fixBrokenGlobbracks(String content) {
        return this.fixBrokenThings(GLOB_BRACK_FIXER, content, "$_missing_method_name_", 1);
    }

    private String fixBrokenParens(String content) {
        char[] contents = content.toCharArray();
        StringBuffer buffer = new StringBuffer(contents.length);
        int depth = 0;
        int start = contents.length;
        int cnt = start - 1;
        while (cnt >= 0) {
            if (contents[cnt] == '(') {
                if (--depth < 0) {
                    int eol = cnt;
                    int cnt2 = cnt;
                    while (cnt2 < start) {
                        if (contents[cnt2] == '\r' || contents[cnt2] == '\n') {
                            eol = cnt2;
                            break;
                        }
                        ++cnt2;
                    }
                    buffer.insert(0, contents, eol, start - eol);
                    buffer.insert(0, ')');
                    buffer.insert(0, contents, cnt, eol - cnt);
                    start = cnt;
                    depth = 0;
                }
            } else if (contents[cnt] == ')') {
                ++depth;
            }
            --cnt;
        }
        if (start > 0) {
            buffer.insert(0, contents, 0, start);
        }
        return buffer.toString();
    }

    private String fixBrokenCommas(String content) {
        String content2 = content;
        content2 = this.fixBrokenThings(COMMA_FIXER1, content2, ",_m_key_ => _m_value__ ", 1);
        content2 = this.fixBrokenThings(COMMA_FIXER2, content2, ",_missing_param_name__ ", 1);
        content2 = this.fixBrokenThings(COMMA_FIXER3, content2, "_m_key_ => _m_value__ ", 1);
        content2 = this.fixBrokenThings(COMMA_FIXER4, content2, ",_m_key_ => _m_value__", 1);
        content2 = this.fixBrokenThings(COMMA_FIXER5, content2, ",_missing_param_name__", 1);
        return this.fixBrokenThings(COMMA_FIXER6, content2, "_m_key_ => _m_value__ ", 1);
    }

    private String fixBrokenCommasUnsafe(String content) {
        String content2 = content;
        content2 = this.fixBrokenThings(COMMA_FIXER_UNSAFE1, content2, ",_m_key_ => _m_value__", 1);
        content2 = this.fixBrokenThings(COMMA_FIXER_UNSAFE2, content2, ",_missing_param_name__", 1);
        return this.fixBrokenThings(COMMA_FIXER_UNSAFE3, content2, "_m_key_ => _m_value__ ", 1);
    }

    private String fixBrokenHashes(String content) {
        String content2 = content;
        content2 = this.fixBrokenThings(HASH_FIXER1, content2, "=>_missing_param_name__ ", 2);
        return this.fixBrokenThings(HASH_FIXER2, content2, "=>_missing_param_name__", 2);
    }

    private String fixBrokenHashesUnsafe(String content) {
        String content2 = content;
        content2 = this.fixBrokenThings(HASH_FIXER_UNSAFE1, content2, "=>_missing_param_name__", 2);
        return this.fixBrokenThings(HASH_FIXER_UNSAFE2, content2, " _missing_method_name_ ", 1);
    }

    public RubyParserResult getParserResult() {
        return this.parserResult;
    }

    protected NodeVisitor getASTBuilderVisitor(ModuleDeclaration module, char[] content) {
        return new RubyASTBuildVisitor(module, content);
    }

    private boolean isMethodNameChar(char inputChar, char prevChar) {
        return inputChar >= 'a' && inputChar <= 'z' || inputChar >= '0' && inputChar <= '9' || inputChar >= 'A' && inputChar <= 'Z' || inputChar == '_' || inputChar == '?' && this.isMethodNameChar(prevChar, '@') || inputChar == '!' && this.isMethodNameChar(prevChar, '@');
    }

    private boolean isPrefixKeyword(char[] content, int endOffset) {
        boolean isPrefixKeyword = false;
        int startOffset = -1;
        if (endOffset >= 5 && !(isPrefixKeyword = "return".equals(String.valueOf(content, startOffset = endOffset - 5, 6)))) {
            isPrefixKeyword = "unless".equals(String.valueOf(content, startOffset, 6));
        }
        if (!isPrefixKeyword && endOffset >= 4) {
            startOffset = endOffset - 4;
            isPrefixKeyword = "while".equals(String.valueOf(content, startOffset, 5));
            if (!isPrefixKeyword) {
                isPrefixKeyword = "elsif".equals(String.valueOf(content, startOffset, 5));
            }
            if (!isPrefixKeyword) {
                isPrefixKeyword = "until".equals(String.valueOf(content, startOffset, 5));
            }
        }
        if (!isPrefixKeyword && endOffset >= 3 && !(isPrefixKeyword = "then".equals(String.valueOf(content, startOffset = endOffset - 3, 4)))) {
            isPrefixKeyword = "case".equals(String.valueOf(content, startOffset, 4));
        }
        if (!isPrefixKeyword && endOffset >= 2) {
            startOffset = endOffset - 2;
            isPrefixKeyword = "and".equals(String.valueOf(content, startOffset, 3));
        }
        if (!isPrefixKeyword && endOffset >= 1 && !(isPrefixKeyword = "if".equals(String.valueOf(content, startOffset = endOffset - 1, 2)))) {
            isPrefixKeyword = "or".equals(String.valueOf(content, startOffset, 2));
        }
        if (isPrefixKeyword) {
            isPrefixKeyword = startOffset == 0 || !this.isMethodNameChar(content[startOffset - 1], startOffset > 1 ? content[startOffset - 2] : (char)'@');
        }
        return isPrefixKeyword;
    }

    private char[] fixSpacedParens(char[] content) {
        char[] fixedContent = new char[content.length];
        System.arraycopy(content, 0, fixedContent, 0, content.length);
        boolean inComment = false;
        boolean inSingleString = false;
        boolean inDoubleString = false;
        boolean inBackQuoteString = false;
        boolean inBraceString = false;
        boolean inInterpString = false;
        boolean inRegexp = false;
        int cnt = 0;
        int max = fixedContent.length;
        while (cnt < max) {
            if (!(cnt <= 1 || inComment || inSingleString || inDoubleString || inBackQuoteString || inBraceString || inRegexp || fixedContent[cnt] != '(' || fixedContent[cnt - 1] != ' ')) {
                if (this.isMethodNameChar(fixedContent[cnt - 2], cnt > 2 ? fixedContent[cnt - 3] : (char)'@') && !this.isPrefixKeyword(fixedContent, cnt - 2)) {
                    fixedContent[cnt - 1] = 40;
                    fixedContent[cnt] = 32;
                }
            } else if (fixedContent[cnt] == '#') {
                if ((inSingleString || inDoubleString || inBackQuoteString || inBraceString || inRegexp) && fixedContent[cnt + 1] == '{') {
                    inInterpString = true;
                } else if (!(inSingleString || inDoubleString || inBackQuoteString || inBraceString)) {
                    inComment = true;
                }
            } else if (fixedContent[cnt] == '\r' || fixedContent[cnt] == '\n') {
                inComment = false;
            } else if (fixedContent[cnt] == '\"') {
                if ((cnt < 1 || fixedContent[cnt - 1] != '\\') && !inComment & !inInterpString) {
                    inDoubleString = !inDoubleString;
                }
            } else if (fixedContent[cnt] == '\'') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment)) {
                    inSingleString = !inSingleString;
                }
            } else if (fixedContent[cnt] == '`') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment)) {
                    inBackQuoteString = !inBackQuoteString;
                }
            } else if (fixedContent[cnt] == '{') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] != '%' || inComment)) {
                    inBraceString = true;
                }
            } else if (fixedContent[cnt] == '}') {
                if (!(cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment)) {
                    if (inInterpString) {
                        inInterpString = false;
                    } else {
                        inBraceString = false;
                    }
                }
            } else if (!(fixedContent[cnt] != '/' || cnt >= 1 && fixedContent[cnt - 1] == '\\' || inComment || inSingleString || inDoubleString || inBackQuoteString || inBraceString)) {
                inRegexp = !inRegexp;
            }
            ++cnt;
        }
        return fixedContent;
    }

    public ModuleDeclaration parse(char[] fileName, char[] content, IProblemReporter reporter) {
        this.problemReporter = reporter;
        try {
            Node node;
            DLTKRubyParser parser = new DLTKRubyParser();
            ProxyProblemReporter proxyProblemReporter = new ProxyProblemReporter(this.problemReporter);
            this.errorState[0] = false;
            long sTime = TRACE_AST_DLTK ? System.currentTimeMillis() : 0L;
            final String strFileName = fileName != null ? String.valueOf(fileName) : "";
            char[] fixedContent = this.fixSpacedParens(content);
            if (!Arrays.equals(fixedContent, content)) {
                parser.parse(strFileName, new CharArrayReader(content), (IProblemReporter)proxyProblemReporter);
                node = parser.parse(strFileName, new CharArrayReader(fixedContent), null);
            } else {
                node = parser.parse(strFileName, new CharArrayReader(content), (IProblemReporter)proxyProblemReporter);
            }
            this.fixPositions.clear();
            if (!parser.isSuccess() || this.errorState[0]) {
                String content2 = this.fixBrokenDots(String.valueOf(fixedContent));
                content2 = this.fixBrokenColons(content2);
                content2 = this.fixBrokenDollars(content2);
                content2 = this.fixBrokenAts(content2);
                content2 = this.fixBrokenInstbracks(content2);
                content2 = this.fixBrokenGlobbracks(content2);
                content2 = this.fixBrokenParens(content2);
                content2 = this.fixBrokenCommas(content2);
                Node node2 = parser.parse(strFileName, new StringReader(content2 = this.fixBrokenHashes(content2)), null);
                if (node2 != null) {
                    node = node2;
                } else {
                    this.fixPositions.clear();
                    content2 = this.fixBrokenColonsUnsafe(content2);
                    content2 = this.fixBrokenCommasUnsafe(content2);
                    content2 = this.fixBrokenHashesUnsafe(content2);
                    node2 = parser.parse(strFileName, new StringReader(content2), (IProblemReporter)new AbstractProblemReporter(){

                        public IMarker reportProblem(IProblem problem) {
                            if (DLTKCore.DEBUG) {
                                System.out.println("JRubySourceParser.parse(): Fallback Parse Problem - fileName=" + strFileName + ", message=" + problem.getMessage() + ", line=" + problem.getSourceLineNumber());
                            }
                            return null;
                        }
                    });
                    if (node2 != null) {
                        node = node2;
                    } else {
                        this.fixPositions.clear();
                    }
                }
                content = content2.toCharArray();
            }
            ModuleDeclaration module = new ModuleDeclaration(content.length);
            NodeVisitor visitor = this.getASTBuilderVisitor(module, content);
            if (node != null) {
                node.accept(visitor);
            }
            if (node != null) {
                if (TRACE_AST_JRUBY || TRACE_AST_DLTK) {
                    System.out.println("\n\nAST rebuilt\n");
                }
                if (TRACE_AST_JRUBY) {
                    System.out.println("JRuby AST:\n" + node.toString());
                }
                if (TRACE_AST_DLTK) {
                    System.out.println("DLTK AST:\n" + module.toString());
                }
            }
            if (!this.fixPositions.isEmpty()) {
                try {
                    module.traverse((ASTVisitor)new ASTPositionsCorrector());
                }
                catch (Exception e) {
                    RubyPlugin.log(e);
                }
            }
            if (TRACE_AST_DLTK) {
                long eTime = System.currentTimeMillis();
                System.out.println("Parsing took " + (eTime - sTime) + " ms");
            }
            this.parserResult = parser.getParserResult();
            if (!parser.isSuccess() && module.isEmpty()) {
                module = new FakeModuleDeclaration(content.length);
                JRubySourceParser.minimumParse(content, module);
            }
            return module;
        }
        catch (Throwable t) {
            if (DLTKCore.DEBUG) {
                t.printStackTrace();
            }
            if (JRubySourceParser.isSilentState()) {
                ModuleDeclaration mdl = new ModuleDeclaration(1);
                return mdl;
            }
            throw new RuntimeException(t);
        }
    }

    public ModuleDeclaration parse(String source) {
        return this.parse(null, source.toCharArray(), null);
    }

    private static void minimumParse(char[] content, ModuleDeclaration md) {
        StringTokenizer toker = new StringTokenizer(new String(content));
        while (toker.hasMoreTokens()) {
            String superClass;
            String className;
            String token = toker.nextToken();
            if (!token.equals("class") && !token.equals("module") || !RubySyntaxUtils.isValidClass(className = toker.nextToken())) continue;
            String source = new String(content);
            int indexOf = source.indexOf(className);
            int nameEnd = indexOf + className.length();
            ConstantReference nameNode = new ConstantReference(indexOf, nameEnd, className);
            Block bodyBlock = new Block(indexOf + nameEnd, source.length() - 1);
            RubyModuleDeclaration type = token.equals("class") ? new RubyClassDeclaration(null, (ASTNode)nameNode, bodyBlock, indexOf, source.length() - 1) : new RubyModuleDeclaration((ASTNode)nameNode, bodyBlock, indexOf, source.length() - 1);
            md.addStatement((Statement)type);
            if (toker.nextToken().equals("<") && RubySyntaxUtils.isValidClass(superClass = toker.nextToken())) {
                indexOf = source.indexOf(className);
                type.addSuperClass((ASTNode)new ConstantReference(indexOf, indexOf + superClass.length(), superClass));
            }
            return;
        }
    }

    private final class ASTPositionsCorrector
    extends ASTVisitor {
        private ASTPositionsCorrector() {
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node.sourceStart() < 0 || node.sourceEnd() < 0) {
                return true;
            }
            int st = 0;
            int en = 0;
            int n_st = 0;
            int n_en = 0;
            Iterator iterator = JRubySourceParser.this.fixPositions.iterator();
            while (iterator.hasNext()) {
                Integer pos = (Integer)iterator.next();
                int fixPos = pos;
                if (node.sourceStart() > fixPos) {
                    ++st;
                }
                if (node.sourceEnd() > fixPos) {
                    ++en;
                }
                if (!(node instanceof Declaration)) continue;
                Declaration declaration = (Declaration)node;
                if (declaration.getNameStart() > fixPos) {
                    ++n_st;
                }
                if (declaration.getNameEnd() <= fixPos) continue;
                ++n_en;
            }
            node.setStart(node.sourceStart() - st * magicLength);
            node.setEnd(node.sourceEnd() - en * magicLength);
            if (node instanceof Declaration) {
                Declaration declaration = (Declaration)node;
                declaration.setNameStart(declaration.getNameStart() - n_st * magicLength);
                declaration.setNameEnd(declaration.getNameEnd() - n_en * magicLength);
            }
            return true;
        }
    }

    private class ProxyProblemReporter
    extends ProblemReporterProxy {
        public ProxyProblemReporter(IProblemReporter original) {
            super(original);
        }

        public IMarker reportProblem(IProblem problem) throws CoreException {
            if (problem.isError()) {
                ((JRubySourceParser)JRubySourceParser.this).errorState[0] = true;
            }
            return super.reportProblem(problem);
        }
    }
}

