/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.AliasedRubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinAlias;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parser.mixin.SuperclassReferenceInfo;
import org.eclipse.dltk.ruby.typeinference.IMixinSearchRequestor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubyMixinClass
implements IRubyMixinElement {
    private final String key;
    protected final RubyMixinModel model;
    private final boolean module;

    public RubyMixinClass(RubyMixinModel model, String key, boolean module) {
        this.model = model;
        this.key = key;
        this.module = module;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isModule() {
        return this.module;
    }

    public RubyMixinClass getInstanceClass() {
        if (!this.isMeta()) {
            return this;
        }
        String newkey = String.valueOf(this.key) + "%";
        IRubyMixinElement r = this.model.createRubyElement(newkey);
        if (r instanceof RubyMixinClass) {
            return (RubyMixinClass)r;
        }
        return null;
    }

    public RubyMixinClass getMetaclass() {
        if (this.isMeta()) {
            return this;
        }
        String metakey = this.key.substring(0, this.key.indexOf("%"));
        IRubyMixinElement r = this.model.createRubyElement(metakey);
        if (r instanceof RubyMixinClass) {
            return (RubyMixinClass)r;
        }
        return null;
    }

    public boolean isMeta() {
        return !this.key.endsWith("%") && !this.key.endsWith("%v");
    }

    public String getName() {
        String name = this.key.substring(this.key.lastIndexOf("{"));
        int pos = name.indexOf("%");
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public IType[] getSourceTypes() {
        ArrayList<Object> result = new ArrayList<Object>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && (info.getKind() == 0 || info.getKind() == 1) && info.getObject() != null) {
                result.add(info.getObject());
            }
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    public RubyMixinClass getSuperclass() {
        String key;
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return null;
        }
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            SuperclassReferenceInfo sinfo;
            BasicContext c;
            ExpressionTypeGoal g;
            DLTKTypeInferenceEngine engine;
            IEvaluatedType type2;
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && info.getKind() == 6 && (type2 = (engine = new DLTKTypeInferenceEngine()).evaluateType((AbstractTypeGoal)(g = new ExpressionTypeGoal((IContext)(c = new BasicContext((sinfo = (SuperclassReferenceInfo)info.getObject()).getModule(), sinfo.getDecl())), sinfo.getNode())), 500)) instanceof RubyClassType) {
                RubyClassType rubyClassType = (RubyClassType)type2;
                String key2 = rubyClassType.getModelKey();
                if (!this.isMeta()) {
                    key2 = String.valueOf(key2) + "%";
                }
                return (RubyMixinClass)this.model.createRubyElement(key2);
            }
            ++i;
        }
        HashSet<String> includeSet = new HashSet<String>();
        RubyMixinClass[] includedClasses = this.model.createRubyClass(new RubyClassType("Object%")).getIncluded();
        int cnt = 0;
        int max = includedClasses.length;
        while (cnt < max) {
            includeSet.add(includedClasses[cnt].getKey());
            ++cnt;
        }
        if (this.isMeta()) {
            key = this.isModule() ? "Module%" : "Class%";
        } else {
            if (this.isModule() && ("Kernel%".equals(this.key) || includeSet.contains(this.getKey()))) {
                return null;
            }
            key = "Object";
        }
        if (!this.isMeta()) {
            key = String.valueOf(key) + "%";
        }
        RubyMixinClass s = (RubyMixinClass)this.model.createRubyElement(key);
        return s;
    }

    public RubyMixinClass[] getIncluded() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        HashSet<String> names = new HashSet<String>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return new RubyMixinClass[0];
        }
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            String inclKey;
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && info.getKind() == 4 && !names.contains(inclKey = (String)info.getObject())) {
                IRubyMixinElement element;
                names.add(inclKey);
                if (!inclKey.endsWith("%")) {
                    inclKey = String.valueOf(inclKey) + "%";
                }
                if ((element = this.model.createRubyElement(inclKey)) instanceof RubyMixinClass) {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new RubyMixinClass[result.size()]);
    }

    public RubyMixinClass[] getExtended() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        HashSet<String> names = new HashSet<String>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return new RubyMixinClass[0];
        }
        Object[] allObjects = mixinElement.getAllObjects();
        int i = 0;
        while (i < allObjects.length) {
            String extKey;
            RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
            if (info != null && info.getKind() == 8 && !names.contains(extKey = (String)info.getObject())) {
                IRubyMixinElement element;
                names.add(extKey);
                if (!extKey.endsWith("%")) {
                    extKey = String.valueOf(extKey) + "%";
                }
                if ((element = this.model.createRubyElement(extKey)) instanceof RubyMixinClass) {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new RubyMixinClass[result.size()]);
    }

    public void findMethods(String prefix, boolean includeTopLevel, IMixinSearchRequestor requestor) {
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return;
        }
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getLastKeySegment().startsWith(prefix)) {
                RubyMixinAlias alias;
                IRubyMixinElement oldElement;
                IRubyMixinElement element = this.model.createRubyElement(children[i]);
                if (element instanceof RubyMixinMethod) {
                    requestor.acceptResult(element);
                }
                if (element instanceof RubyMixinAlias && (oldElement = (alias = (RubyMixinAlias)element).getOldElement()) instanceof RubyMixinMethod) {
                    AliasedRubyMixinMethod a = new AliasedRubyMixinMethod(this.model, alias);
                    requestor.acceptResult(a);
                }
            }
            ++i;
        }
        RubyMixinClass[] included = this.getIncluded();
        int i2 = 0;
        while (i2 < included.length) {
            included[i2].findMethods(prefix, includeTopLevel, requestor);
            ++i2;
        }
        RubyMixinClass[] extended = this.getExtended();
        int i3 = 0;
        while (i3 < extended.length) {
            extended[i3].findMethods(prefix, includeTopLevel, requestor);
            ++i3;
        }
        if (!this.key.endsWith("%v")) {
            RubyMixinClass superclass = this.getSuperclass();
            if (superclass != null && !superclass.getKey().equals(this.key)) {
                RubyMixinMethod[] methods = superclass.findMethods(prefix, includeTopLevel);
                int j = 0;
                while (j < methods.length) {
                    requestor.acceptResult(methods[j]);
                    ++j;
                }
            }
        } else {
            String stdKey = this.key.substring(0, this.key.length() - "%v".length());
            IRubyMixinElement realElement = this.model.createRubyElement(stdKey);
            if (realElement instanceof RubyMixinClass) {
                RubyMixinClass rubyMixinClass = (RubyMixinClass)realElement;
                rubyMixinClass.findMethods(prefix, includeTopLevel, requestor);
            }
        }
    }

    public RubyMixinMethod[] findMethods(String prefix, boolean includeTopLevel) {
        final ArrayList result = new ArrayList();
        final HashSet names = new HashSet();
        this.findMethods(prefix, includeTopLevel, new IMixinSearchRequestor(){

            public void acceptResult(IRubyMixinElement element) {
                RubyMixinMethod method;
                if (element instanceof RubyMixinMethod && names.add((method = (RubyMixinMethod)element).getName())) {
                    result.add(method);
                }
            }
        });
        return result.toArray(new RubyMixinMethod[result.size()]);
    }

    public void findMethodsExact(String methodName, IMixinSearchRequestor requestor) {
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        if (mixinElement == null) {
            return;
        }
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getLastKeySegment().equals(methodName)) {
                RubyMixinAlias alias;
                IRubyMixinElement oldElement;
                IRubyMixinElement element = this.model.createRubyElement(children[i]);
                if (element instanceof RubyMixinMethod) {
                    requestor.acceptResult(element);
                }
                if (element instanceof RubyMixinAlias && (oldElement = (alias = (RubyMixinAlias)element).getOldElement()) instanceof RubyMixinMethod) {
                    AliasedRubyMixinMethod a = new AliasedRubyMixinMethod(this.model, alias);
                    requestor.acceptResult(a);
                }
            }
            ++i;
        }
        RubyMixinClass[] included = this.getIncluded();
        int i2 = 0;
        while (i2 < included.length) {
            included[i2].findMethodsExact(methodName, requestor);
            ++i2;
        }
        RubyMixinClass[] extended = this.getExtended();
        int i3 = 0;
        while (i3 < extended.length) {
            extended[i3].findMethodsExact(methodName, requestor);
            ++i3;
        }
        if (!this.key.endsWith("%v")) {
            RubyMixinClass superclass = this.getSuperclass();
            if (superclass != null && !superclass.getKey().equals(this.key)) {
                RubyMixinMethod[] methods = superclass.findMethodsExact(methodName);
                int j = 0;
                while (j < methods.length) {
                    requestor.acceptResult(methods[j]);
                    ++j;
                }
            }
        } else {
            String stdKey = this.key.substring(0, this.key.length() - "%v".length());
            IRubyMixinElement realElement = this.model.createRubyElement(stdKey);
            if (realElement instanceof RubyMixinClass) {
                RubyMixinClass rubyMixinClass = (RubyMixinClass)realElement;
                rubyMixinClass.findMethodsExact(methodName, requestor);
            }
        }
    }

    public RubyMixinMethod[] findMethodsExact(String methodName) {
        final ArrayList result = new ArrayList();
        final HashSet names = new HashSet();
        this.findMethodsExact(methodName, new IMixinSearchRequestor(){

            public void acceptResult(IRubyMixinElement element) {
                RubyMixinMethod method;
                if (element instanceof RubyMixinMethod && names.add((method = (RubyMixinMethod)element).getName())) {
                    result.add(method);
                }
            }
        });
        return result.toArray(new RubyMixinMethod[result.size()]);
    }

    public RubyMixinMethod getMethod(String name) {
        String possibleKey = String.valueOf(this.key) + "{" + name;
        IMixinElement mixinElement = this.model.getRawModel().get(possibleKey);
        if (mixinElement != null) {
            RubyMixinAlias alias;
            IRubyMixinElement oldElement;
            IRubyMixinElement element = this.model.createRubyElement(mixinElement);
            if (element instanceof RubyMixinMethod) {
                return (RubyMixinMethod)element;
            }
            if (element instanceof RubyMixinAlias && (oldElement = (alias = (RubyMixinAlias)element).getOldElement()) instanceof RubyMixinMethod) {
                return new AliasedRubyMixinMethod(this.model, alias);
            }
        }
        RubyMixinClass[] included = this.getIncluded();
        int i = 0;
        while (i < included.length) {
            RubyMixinMethod method;
            if (!this.key.equals(included[i].key) && (method = included[i].getMethod(name)) != null) {
                return method;
            }
            ++i;
        }
        RubyMixinClass[] extended = this.getExtended();
        int i2 = 0;
        while (i2 < extended.length) {
            RubyMixinMethod method = extended[i2].getMethod(name);
            if (method != null) {
                return method;
            }
            ++i2;
        }
        RubyMixinClass superclass = this.getSuperclass();
        if (superclass != null) {
            if (superclass.getKey().equals(this.key)) {
                return null;
            }
            return superclass.getMethod(name);
        }
        return null;
    }

    public RubyMixinClass[] getClasses() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinClass) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new RubyMixinClass[result.size()]);
    }

    public RubyMixinVariable[] getFields() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinVariable) {
                result.add(element);
            }
            ++i;
        }
        RubyMixinClass superclass = this.getSuperclass();
        if (superclass != null && superclass.key != "Object" && superclass.key != "Object%") {
            if (superclass.getKey().equals(this.key)) {
                return null;
            }
            RubyMixinVariable[] superFields = superclass.getFields();
            result.addAll(Arrays.asList(superFields));
        }
        return result.toArray(new RubyMixinVariable[result.size()]);
    }
}

