/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.typeinference.FakeField;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;

public class UnknownReference
implements IReference {
    private String name;
    private final boolean childIsh;
    boolean fRef;
    boolean local;
    protected ModelElement parent;
    private int offset;
    private int length;
    HashMap childs;
    private char[][] parameterNames;
    private Object proposalInfo;

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public UnknownReference(String paramOrVarName, boolean childIsh) {
        this.name = paramOrVarName;
        this.childIsh = childIsh;
    }

    public void setLocationInformation(ModelElement parent, int offset, int length) {
        this.parent = parent;
        this.length = length;
        this.offset = offset;
    }

    public Set getChilds(boolean resolveLocals) {
        if (this.childs == null) {
            return new HashSet(1);
        }
        return new HashSet(this.childs.values());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getParentName() {
        return this.name;
    }

    public IReference getChild(String key, boolean resolveLocals) {
        if (this.childs == null) {
            return null;
        }
        IReference r = (IReference)this.childs.get(key);
        return r;
    }

    public void setChild(String key, IReference ref) {
        if (this.childs == null) {
            this.childs = new HashMap();
        }
        this.childs.put(key, ref);
    }

    public boolean isChildishReference() {
        return this.childIsh;
    }

    public void recordDelete(String fieldId) {
        if (this.childs == null) {
            return;
        }
        this.childs.remove(fieldId);
    }

    public IReference getPrototype(boolean resolveLocals) {
        return this.getChild("prototype", true);
    }

    public void setPrototype(IReference ref) {
        this.setChild("prototype", ref);
    }

    public void addModelElements(Collection toAdd) {
        if (this.parent != null) {
            toAdd.add(new FakeField(this.parent, this.name, this.offset, this.length));
        }
    }

    public boolean isFunctionRef() {
        return this.fRef;
    }

    public void setFunctionRef() {
        this.fRef = true;
    }

    public char[][] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(char[][] parameterNames) {
        this.parameterNames = parameterNames;
    }

    public Object getProposalInfo() {
        return this.proposalInfo;
    }

    public void setProposalInfo(Object proposalInfo) {
        this.proposalInfo = proposalInfo;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }
}

