/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;

public class OrReference
implements IReference {
    protected final IReference one;
    protected final IReference second;
    boolean entered = false;

    public OrReference(IReference one, IReference second) {
        this.one = one;
        this.second = second;
    }

    public Set getChilds(boolean resolveLocals) {
        if (this.entered) {
            return new HashSet();
        }
        this.entered = true;
        Set set = this.one.getChilds(resolveLocals);
        set.addAll(this.second.getChilds(resolveLocals));
        this.entered = false;
        return set;
    }

    public String getName() {
        return this.one.getName();
    }

    public int hashCode() {
        int result = 1;
        if (this.entered) {
            return result;
        }
        this.entered = true;
        result = 31 * result + (this.one == null ? 0 : this.one.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        this.entered = false;
        return result;
    }

    public boolean equals(Object obj) {
        if (this.entered) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrReference other = (OrReference)obj;
        if (this.one == null ? other.one != null : !this.one.equals(other.one)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public IReference getChild(String key, boolean resolveLocals) {
        if (this.entered) {
            return null;
        }
        this.entered = true;
        IReference child = this.one.getChild(key, resolveLocals);
        IReference child2 = this.second.getChild(key, resolveLocals);
        this.entered = false;
        if (child == null) {
            return child2;
        }
        if (child2 == null) {
            return child;
        }
        if (child == child2) {
            return child;
        }
        return new OrReference(child, child2);
    }

    public void setChild(String key, IReference ref) {
        this.one.setChild(key, ref);
        this.second.setChild(key, ref);
    }

    public boolean isChildishReference() {
        return this.one.isChildishReference() || this.second.isChildishReference();
    }

    public void recordDelete(String fieldId) {
    }

    public IReference getPrototype(boolean resolveLocals) {
        IReference prototype = this.one.getPrototype(false);
        IReference prototype2 = this.second.getPrototype(false);
        if (prototype == null) {
            return prototype2;
        }
        if (prototype2 == null) {
            return prototype;
        }
        return new OrReference(prototype, prototype2);
    }

    public void setPrototype(IReference ref) {
        this.one.setPrototype(ref);
        this.second.setPrototype(ref);
    }

    public void addModelElements(Collection toAdd) {
        this.one.addModelElements(toAdd);
        this.second.addModelElements(toAdd);
    }

    public void setLocationInformation(ModelElement mo, int position, int length) {
        this.one.setLocationInformation(mo, position, length);
        this.second.setLocationInformation(mo, position, length);
    }

    public boolean isFunctionRef() {
        return this.one.isFunctionRef() || this.second.isFunctionRef();
    }

    public boolean isLocal() {
        return this.one.isLocal() || this.second.isLocal();
    }

    public void setLocal(boolean local) {
        this.one.setLocal(local);
        this.second.setLocal(local);
    }
}

